/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.internal;

import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import com.kdgregory.logging.aws.internal.AbstractWriterStatistics;
import com.kdgregory.logging.common.LogMessage;
import com.kdgregory.logging.common.LogWriter;
import com.kdgregory.logging.common.internal.Utils;
import com.kdgregory.logging.common.util.InternalLogger;
import com.kdgregory.logging.common.util.MessageQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractLogWriter<ConfigType extends AbstractWriterConfig<ConfigType>, StatsType extends AbstractWriterStatistics>
implements LogWriter {
    private static final long NEVER_SHUTDOWN = Long.MAX_VALUE;
    protected ConfigType config;
    protected StatsType stats;
    protected InternalLogger logger;
    private MessageQueue messageQueue;
    private Thread dispatchThread;
    private volatile long shutdownTime = Long.MAX_VALUE;
    private volatile Thread shutdownHook;
    private volatile boolean initializationComplete;
    private volatile boolean isRunning;
    private volatile int batchCount;

    public AbstractLogWriter(ConfigType config, StatsType appenderStats, InternalLogger logger) {
        this.config = config;
        this.stats = appenderStats;
        this.logger = logger;
        this.messageQueue = new MessageQueue(((AbstractWriterConfig)config).getDiscardThreshold(), ((AbstractWriterConfig)config).getDiscardAction());
        ((AbstractWriterStatistics)this.stats).setMessageQueue(this.messageQueue);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public long getBatchDelay() {
        return ((AbstractWriterConfig)this.config).getBatchDelay();
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    @Override
    public void run() {
        this.logger.debug("log writer starting (thread: " + Thread.currentThread().getName() + ")");
        if (!this.initialize()) {
            this.logger.error("log writer failed to initialize (thread: " + Thread.currentThread().getName() + ")", null);
            return;
        }
        this.isRunning = true;
        this.logger.debug("log writer initialization complete (thread: " + Thread.currentThread().getName() + ")");
        this.dispatchThread = Thread.currentThread();
        do {
            if (((AbstractWriterConfig)this.config).getSynchronousMode()) {
                long timeToShutdown = this.shutdownTime - System.currentTimeMillis();
                Utils.sleepQuietly(timeToShutdown);
                continue;
            }
            this.processBatch(this.shutdownTime);
        } while (this.keepRunning());
        this.cleanup();
        this.isRunning = false;
        this.logger.debug("log-writer shut down (thread: " + Thread.currentThread().getName() + " (#" + Thread.currentThread().getId() + ")");
    }

    @Override
    public void setBatchDelay(long value) {
        ((AbstractWriterConfig)this.config).setBatchDelay(value);
    }

    @Override
    public void setDiscardThreshold(int value) {
        this.messageQueue.setDiscardThreshold(value);
    }

    @Override
    public void setDiscardAction(MessageQueue.DiscardAction value) {
        this.messageQueue.setDiscardAction(value);
    }

    @Override
    public boolean isSynchronous() {
        return ((AbstractWriterConfig)this.config).getSynchronousMode();
    }

    @Override
    public boolean waitUntilInitialized(long millisToWait) {
        long timeoutAt = System.currentTimeMillis() + millisToWait;
        while (!this.initializationComplete && System.currentTimeMillis() < timeoutAt) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                return false;
            }
        }
        return this.initializationComplete;
    }

    @Override
    public void addMessage(LogMessage message) {
        if (message.size() == 0) {
            this.logger.warn("discarded empty message");
            return;
        }
        if (message.size() > this.maxMessageSize()) {
            ((AbstractWriterStatistics)this.stats).incrementOversizeMessages();
            if (((AbstractWriterConfig)this.config).getTruncateOversizeMessages()) {
                this.logger.warn("truncated oversize message (" + message.size() + " bytes to " + this.maxMessageSize() + ")");
                message.truncate(this.maxMessageSize());
            } else {
                this.logger.warn("discarded oversize message (" + message.size() + " bytes, limit is " + this.maxMessageSize() + ")");
                return;
            }
        }
        this.messageQueue.enqueue(message);
        if (((AbstractWriterConfig)this.config).getSynchronousMode()) {
            this.processBatch(System.currentTimeMillis());
        }
    }

    @Override
    public void stop() {
        if (this.shutdownTime != Long.MAX_VALUE) {
            return;
        }
        this.shutdownTime = System.currentTimeMillis() + ((AbstractWriterConfig)this.config).getBatchDelay();
        if (this.dispatchThread != null) {
            this.dispatchThread.interrupt();
        }
    }

    @Override
    public void waitUntilStopped(long millisToWait) {
        try {
            if (this.dispatchThread != null && this.dispatchThread != Thread.currentThread()) {
                this.dispatchThread.join(millisToWait);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected boolean keepRunning() {
        return this.shutdownTime > System.currentTimeMillis() || !this.messageQueue.isEmpty();
    }

    protected boolean initialize() {
        boolean success = true;
        try {
            success = this.ensureDestinationAvailable();
            this.optAddShutdownHook();
        }
        catch (Exception ex) {
            this.reportError("exception in initializer", ex);
            success = false;
        }
        if (!success) {
            this.messageQueue.setDiscardThreshold(0);
            this.messageQueue.setDiscardAction(MessageQueue.DiscardAction.oldest);
        }
        this.initializationComplete = true;
        return success;
    }

    protected synchronized void processBatch(long waitUntil) {
        List<LogMessage> currentBatch = this.buildBatch(waitUntil);
        if (currentBatch.size() > 0) {
            ++this.batchCount;
            List<LogMessage> failures = this.sendBatch(currentBatch);
            this.requeueMessages(failures);
            ((AbstractWriterStatistics)this.stats).setMessagesRequeuedLastBatch(failures.size());
            ((AbstractWriterStatistics)this.stats).setMessagesSentLastBatch(currentBatch.size() - failures.size());
            ((AbstractWriterStatistics)this.stats).updateMessagesSent(currentBatch.size() - failures.size());
        }
    }

    protected List<LogMessage> buildBatch(long waitUntil) {
        ArrayList<LogMessage> batch = new ArrayList<LogMessage>(512);
        LogMessage message = this.waitForMessage(waitUntil);
        if (message == null) {
            return batch;
        }
        long batchTimeout = System.currentTimeMillis() + ((AbstractWriterConfig)this.config).getBatchDelay();
        int batchBytes = 0;
        int batchMsgs = 0;
        while (message != null) {
            if (!this.withinServiceLimits(batchBytes += this.effectiveSize(message), ++batchMsgs)) {
                this.messageQueue.requeue(message);
                break;
            }
            batch.add(message);
            message = this.waitForMessage(batchTimeout);
        }
        return batch;
    }

    private LogMessage waitForMessage(long waitUntil) {
        long waitTime = Math.max(1L, waitUntil - System.currentTimeMillis());
        return this.messageQueue.dequeue(waitTime);
    }

    private void requeueMessages(List<LogMessage> messages) {
        Collections.reverse(messages);
        for (LogMessage message : messages) {
            this.messageQueue.requeue(message);
        }
    }

    private void cleanup() {
        this.stopAWSClient();
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception exception) {
            }
            finally {
                this.shutdownHook = null;
            }
        }
    }

    private void optAddShutdownHook() {
        if (((AbstractWriterConfig)this.config).getUseShutdownHook()) {
            this.shutdownHook = new Thread(new Runnable(){

                @Override
                public void run() {
                    AbstractLogWriter.this.logger.debug("shutdown hook invoked");
                    AbstractLogWriter.this.setBatchDelay(1L);
                    AbstractLogWriter.this.stop();
                    try {
                        if (AbstractLogWriter.this.dispatchThread != null) {
                            AbstractLogWriter.this.dispatchThread.join();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            this.shutdownHook.setName(Thread.currentThread().getName() + "-shutdownHook");
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    protected abstract boolean ensureDestinationAvailable();

    protected abstract List<LogMessage> sendBatch(List<LogMessage> var1);

    protected abstract int effectiveSize(LogMessage var1);

    protected abstract boolean withinServiceLimits(int var1, int var2);

    protected abstract void stopAWSClient();

    protected void reportError(String message, Throwable exception) {
        this.logger.error(message, exception);
        ((AbstractWriterStatistics)this.stats).setLastError(message, exception);
    }
}

