/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.common.util;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Deprecated
public class RetryManager {
    private long initialDuration;
    private long timeout;
    private boolean isExponential;
    private Consumer<RuntimeException> uncaughtHandler = new Consumer<RuntimeException>(){

        @Override
        public void accept(RuntimeException ex) {
            throw ex;
        }
    };

    public RetryManager(long initialDuration, long timeout, boolean isExponential) {
        this.initialDuration = initialDuration;
        this.timeout = timeout;
        this.isExponential = isExponential;
    }

    public RetryManager(Duration initialDuration, Duration timeout, boolean isExponential) {
        this(initialDuration.toMillis(), timeout.toMillis(), isExponential);
    }

    public <T> T invoke(Supplier<T> supplier) {
        return this.invoke(supplier, this.uncaughtHandler);
    }

    public <T> T invoke(Supplier<T> supplier, Consumer<RuntimeException> exceptionHandler) {
        long runUntil = System.currentTimeMillis() + this.timeout;
        long currentSleep = this.initialDuration;
        while (System.currentTimeMillis() < runUntil) {
            try {
                T result = supplier.get();
                if (result != null) {
                    return result;
                }
            }
            catch (RuntimeException ex) {
                exceptionHandler.accept(ex);
            }
            RetryManager.sleepQuietly(currentSleep);
            if (!this.isExponential) continue;
            currentSleep *= 2L;
        }
        return null;
    }

    public static boolean sleepQuietly(long duration) {
        try {
            Thread.sleep(duration);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }
}

