/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade;

import java.util.Arrays;
import java.util.stream.Collectors;

public class FacadeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String functionName;
    private boolean isRetryable;

    public FacadeException(String message, Throwable cause, boolean isRetryable, String functionName, Object ... args) {
        super(FacadeException.constructMessage(message, functionName, args), cause);
        this.isRetryable = isRetryable;
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public boolean isRetryable() {
        return this.isRetryable;
    }

    private static String constructMessage(String message, String functionName, Object ... args) {
        if (functionName == null || functionName.isEmpty()) {
            return message;
        }
        String functionCall = functionName + Arrays.asList(args).stream().map(String::valueOf).collect(Collectors.joining(",", "(", "): "));
        return functionCall + message;
    }
}

