/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.sns;

import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import java.util.ArrayList;
import java.util.List;

public class SNSWriterConfig
extends AbstractWriterConfig<SNSWriterConfig> {
    public static final long DEFAULT_INITIALIZATION_TIMEOUT = 30000L;
    private String topicName;
    private String topicArn;
    private String subject;
    private boolean autoCreate;

    public SNSWriterConfig() {
        super(30000L);
        super.setBatchDelay(1L);
    }

    public String getTopicName() {
        return this.topicName;
    }

    public SNSWriterConfig setTopicName(String value) {
        this.topicName = value != null && value.trim().isEmpty() ? null : value;
        return this;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public SNSWriterConfig setTopicArn(String value) {
        this.topicArn = value != null && value.trim().isEmpty() ? null : value;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public SNSWriterConfig setSubject(String value) {
        this.subject = value;
        return this;
    }

    public boolean getAutoCreate() {
        return this.autoCreate;
    }

    public SNSWriterConfig setAutoCreate(boolean value) {
        this.autoCreate = value;
        return this;
    }

    @Override
    public SNSWriterConfig setBatchDelay(long value) {
        return this;
    }

    public List<String> validate() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.topicName == null && this.topicArn == null) {
            result.add("must specify either ARN or topic name");
        }
        if (this.topicName != null && !this.topicName.matches("[A-Za-z0-9_-]{1,256}")) {
            result.add("invalid SNS topic name: " + this.topicName);
        }
        if (this.topicArn != null && !this.topicArn.matches("arn:aws[-a-z]*:sns:[-a-z]*-[0-9]:\\d{12}:[A-Za-z0-9_-]{1,256}")) {
            result.add("invalid SNS topic ARN: " + this.topicArn);
        }
        if (this.subject != null && this.subject.length() > 100) {
            result.add("invalid SNS subject: over 100 characters");
        }
        if (this.subject != null && this.subject.charAt(0) == ' ') {
            result.add("invalid SNS subject: begins with space");
        }
        if (this.subject != null) {
            for (int ii = 0; ii < this.subject.length(); ++ii) {
                if (this.subject.charAt(ii) > '\u007f') {
                    result.add("invalid SNS subject: must contain ASCII characters only");
                    break;
                }
                if (this.subject.charAt(ii) >= ' ' && this.subject.charAt(ii) != '\u007f') continue;
                result.add("invalid SNS subject: may not contain control characters or newlines");
                break;
            }
        }
        if (this.autoCreate && this.topicArn != null) {
            result.add("must not specify ARN if auto-create enabled");
        }
        return result;
    }
}

