/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.common;

import java.nio.charset.StandardCharsets;

public class LogMessage
implements Comparable<LogMessage> {
    private long timestamp;
    private String message;
    private byte[] messageBytes;

    public LogMessage(long timestamp, String message) {
        this.timestamp = timestamp;
        this.message = message;
        this.messageBytes = message.getBytes(StandardCharsets.UTF_8);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int size() {
        return this.messageBytes.length;
    }

    public String getMessage() {
        return this.message;
    }

    public byte[] getBytes() {
        return this.messageBytes;
    }

    public void truncate(int maxSize) {
        int idx;
        if (this.size() <= maxSize) {
            return;
        }
        int curFlag = 0;
        for (idx = maxSize; idx > 0 && (curFlag = this.messageBytes[idx] & 0xC0) == 128; --idx) {
        }
        if (curFlag == 192) {
            --idx;
        }
        int newSize = Math.min(maxSize, idx + 1);
        byte[] newBytes = new byte[newSize];
        System.arraycopy(this.messageBytes, 0, newBytes, 0, newSize);
        this.messageBytes = newBytes;
        this.message = new String(this.messageBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int compareTo(LogMessage that) {
        return this.timestamp < that.timestamp ? -1 : (this.timestamp > that.timestamp ? 1 : 0);
    }
}

