/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.common.util;

import com.kdgregory.logging.common.LogWriter;
import com.kdgregory.logging.common.util.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultThreadFactory
implements ThreadFactory {
    private static AtomicInteger threadNumber = new AtomicInteger(0);
    private String appenderName;

    public DefaultThreadFactory(String appenderName) {
        this.appenderName = appenderName;
    }

    @Override
    public void startWriterThread(LogWriter writer, Thread.UncaughtExceptionHandler exceptionHandler) {
        if (writer.isSynchronous()) {
            try {
                writer.run();
            }
            catch (Throwable ex) {
                exceptionHandler.uncaughtException(Thread.currentThread(), ex);
            }
        } else {
            Thread writerThread = this.createThread(writer, exceptionHandler);
            writerThread.start();
        }
    }

    protected Thread createThread(LogWriter writer, Thread.UncaughtExceptionHandler exceptionHandler) {
        Thread writerThread = new Thread(writer);
        writerThread.setName("com-kdgregory-aws-logwriter-" + this.appenderName + "-" + threadNumber.incrementAndGet());
        writerThread.setPriority(5);
        writerThread.setDaemon(true);
        writerThread.setUncaughtExceptionHandler(exceptionHandler);
        return writerThread;
    }
}

