/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.kinesis;

import java.nio.charset.StandardCharsets;

public class PartitionKeyHelper {
    private String literalValue;
    private int length = 6;

    public PartitionKeyHelper(String configuredValue) {
        if (configuredValue != null && !configuredValue.isEmpty() && !configuredValue.equals("{random}")) {
            this.literalValue = configuredValue;
            this.length = configuredValue.getBytes(StandardCharsets.UTF_8).length;
        }
    }

    public boolean isGenerated() {
        return this.literalValue == null;
    }

    public int getLength() {
        return this.length;
    }

    public String getValue() {
        if (this.literalValue != null) {
            return this.literalValue;
        }
        int v = (int)(System.nanoTime() & 0x7FFFFL);
        return String.format("%06d", v);
    }
}

