/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.sns;

import com.kdgregory.logging.aws.facade.SNSFacade;
import com.kdgregory.logging.aws.internal.AbstractLogWriter;
import com.kdgregory.logging.aws.sns.SNSWriterConfig;
import com.kdgregory.logging.aws.sns.SNSWriterStatistics;
import com.kdgregory.logging.common.LogMessage;
import com.kdgregory.logging.common.util.InternalLogger;
import com.kdgregory.logging.common.util.RetryManager2;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class SNSLogWriter
extends AbstractLogWriter<SNSWriterConfig, SNSWriterStatistics> {
    private SNSFacade facade;
    protected Duration describeTimeout = Duration.ofMillis(2000L);
    protected RetryManager2 describeRetry = new RetryManager2("describe", Duration.ofMillis(50L), false, false);
    protected RetryManager2 createRetry = new RetryManager2("create", Duration.ofMillis(200L), true, true);

    public SNSLogWriter(SNSWriterConfig config, SNSWriterStatistics stats, InternalLogger logger, SNSFacade facade) {
        super(config, stats, logger);
        this.facade = facade;
        stats.setActualTopicName(config.getTopicName());
        stats.setActualTopicArn(config.getTopicArn());
        stats.setActualSubject(config.getSubject());
    }

    @Override
    public int maxMessageSize() {
        return 262144;
    }

    @Override
    protected boolean ensureDestinationAvailable() {
        List<String> configErrors = ((SNSWriterConfig)this.config).validate();
        if (!configErrors.isEmpty()) {
            for (String error : configErrors) {
                this.reportError("configuration error: " + error, null);
            }
            return false;
        }
        Instant timeoutAt = Instant.now().plusMillis(((SNSWriterConfig)this.config).getInitializationTimeout());
        try {
            this.logger.debug("checking for existence of SNS topic: " + (((SNSWriterConfig)this.config).getTopicArn() != null ? ((SNSWriterConfig)this.config).getTopicArn() : ((SNSWriterConfig)this.config).getTopicName()));
            String topicArn = this.facade.lookupTopic();
            if (topicArn == null && (topicArn = this.optCreateTopic(timeoutAt)) == null) {
                this.logger.error("failed to create SNS topic", null);
                return false;
            }
            ((SNSWriterConfig)this.config).setTopicArn(topicArn);
            ((SNSWriterStatistics)this.stats).setActualTopicArn(topicArn);
            ((SNSWriterStatistics)this.stats).setActualTopicName(topicArn.replaceAll(".*:", ""));
            return true;
        }
        catch (Throwable ex) {
            this.reportError("exception during initialization", ex);
            return false;
        }
    }

    @Override
    protected List<LogMessage> sendBatch(List<LogMessage> currentBatch) {
        ((SNSWriterStatistics)this.stats).setLastBatchSize(currentBatch.size());
        if (((SNSWriterConfig)this.config).getEnableBatchLogging()) {
            this.logger.debug("about to write batch of " + currentBatch.size() + " message(s)");
        }
        if (currentBatch.isEmpty()) {
            return currentBatch;
        }
        ArrayList<LogMessage> failures = new ArrayList<LogMessage>();
        for (LogMessage message : currentBatch) {
            try {
                this.facade.publish(message);
                if (!((SNSWriterConfig)this.config).getEnableBatchLogging()) continue;
                this.logger.debug("published 1 message");
            }
            catch (Exception ex) {
                this.reportError("failed to publish: " + ex.getMessage(), ex);
                failures.add(message);
            }
        }
        return failures;
    }

    @Override
    protected int effectiveSize(LogMessage message) {
        return message.size();
    }

    @Override
    protected boolean withinServiceLimits(int batchBytes, int numMessages) {
        return batchBytes <= 262144 && numMessages <= 1;
    }

    @Override
    protected void stopAWSClient() {
        this.facade.shutdown();
    }

    private String optCreateTopic(Instant timeoutAt) {
        String topicArn = this.describeRetry.invoke(this.describeTimeout, () -> this.facade.lookupTopic());
        if (topicArn != null) {
            return topicArn;
        }
        if (((SNSWriterConfig)this.config).getTopicArn() != null) {
            this.reportError("topic " + ((SNSWriterConfig)this.config).getTopicArn() + " does not exist", null);
            return null;
        }
        if (!((SNSWriterConfig)this.config).getAutoCreate()) {
            this.reportError("topic " + ((SNSWriterConfig)this.config).getTopicName() + " does not exist and auto-create not enabled", null);
            return null;
        }
        this.logger.debug("creating topic: " + ((SNSWriterConfig)this.config).getTopicName());
        return this.createRetry.invoke(timeoutAt, () -> this.facade.createTopic());
    }
}

