/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.common.internal;

import java.lang.reflect.Method;

public class Utils {
    public static void sleepQuietly(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Class<?> loadClass(String fullyQualifiedName) {
        try {
            return Class.forName(fullyQualifiedName);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static Method findMethodIfExists(Class<?> klass, String methodName, Class<?> ... paramTypes) {
        if (klass == null || methodName == null || methodName.isEmpty()) {
            return null;
        }
        try {
            return klass.getDeclaredMethod(methodName, paramTypes);
        }
        catch (Exception exception) {
            try {
                return klass.getMethod(methodName, paramTypes);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public static Method findFullyQualifiedMethod(String name, Class<?> ... params) throws ClassNotFoundException, NoSuchMethodException {
        if (name == null || name.isEmpty()) {
            return null;
        }
        int methodIdx = name.lastIndexOf(46);
        if (methodIdx <= 0) {
            throw new IllegalArgumentException("invalid factory method name: " + name);
        }
        String className = name.substring(0, methodIdx);
        String methodName = name.substring(methodIdx + 1);
        Class<?> klass = Utils.loadClass(className);
        if (klass == null) {
            throw new ClassNotFoundException(className);
        }
        Method method = Utils.findMethodIfExists(klass, methodName, params);
        if (method == null) {
            throw new NoSuchMethodException("invalid factory method: " + name);
        }
        return method;
    }
}

