/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade;

import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import java.lang.reflect.Constructor;

public class FacadeFactory {
    private static final String[] FACADE_PACKAGES = new String[]{"com.kdgregory.logging.aws.facade.v1", "com.kdgregory.logging.aws.facade.v2"};

    public static <T> T createFacade(Class<T> facadeType, AbstractWriterConfig<?> config) {
        Class<?> implClass = FacadeFactory.findImplementationClass(facadeType);
        return (T)FacadeFactory.instantiate(implClass, config);
    }

    public static <T> T createFacade(Class<T> facadeType) {
        Class<?> implClass = FacadeFactory.findImplementationClass(facadeType);
        return (T)FacadeFactory.instantiate(implClass, new Object[0]);
    }

    private static Class<?> findImplementationClass(Class<?> facadeType) {
        for (String packageName : FACADE_PACKAGES) {
            String className = packageName + "." + facadeType.getSimpleName() + "Impl";
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new IllegalArgumentException("no implementation class for " + facadeType.getName());
    }

    private static Object instantiate(Class<?> implClass, Object ... ctorArgs) {
        try {
            Constructor<?>[] ctors = implClass.getConstructors();
            if (ctors.length != 1) {
                throw new IllegalArgumentException("implementation class does not expose a single constructor: " + implClass.getName());
            }
            return ctors[0].newInstance(ctorArgs);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("unable to instantiate: " + implClass.getName(), ex);
        }
    }
}

