/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.internal;

import com.kdgregory.logging.common.util.MessageQueue;

public class AbstractWriterConfig<T extends AbstractWriterConfig<T>>
implements Cloneable {
    public static final boolean DEFAULT_TRUNCATE_OVERSIZE = true;
    public static final boolean DEFAULT_IS_SYNCHRONOUS = false;
    public static final long DEFAULT_BATCH_DELAY = 2000L;
    public static final int DEFAULT_DISCARD_THRESHOLD = 10000;
    public static final MessageQueue.DiscardAction DEFAULT_DISCARD_ACTION = MessageQueue.DiscardAction.oldest;
    public static final boolean DEFAULT_USE_SHUTDOWN_HOOK = true;
    public static final boolean DEFAULT_ENABLE_BATCH_LOGGING = false;
    private boolean truncateOversizeMessages = true;
    private boolean isSynchronous = false;
    private volatile long batchDelay = 2000L;
    private volatile int discardThreshold = 10000;
    private volatile MessageQueue.DiscardAction discardAction = DEFAULT_DISCARD_ACTION;
    private String clientFactoryMethod;
    private String assumedRole;
    private String clientRegion;
    private String clientEndpoint;
    private boolean useShutdownHook = true;
    private long initializationTimeout;
    private boolean enableBatchLogging = false;

    protected AbstractWriterConfig(long initializationTimeout) {
        this.initializationTimeout = initializationTimeout;
    }

    public AbstractWriterConfig<T> clone() {
        try {
            return (AbstractWriterConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("failed to expose Object.clone(); should never happen", e);
        }
    }

    public boolean getTruncateOversizeMessages() {
        return this.truncateOversizeMessages;
    }

    public T setTruncateOversizeMessages(boolean value) {
        this.truncateOversizeMessages = value;
        return (T)this;
    }

    public boolean getSynchronousMode() {
        return this.isSynchronous;
    }

    public T setSynchronousMode(boolean value) {
        this.isSynchronous = value;
        if (this.isSynchronous) {
            this.batchDelay = 0L;
        } else if (this.batchDelay == 0L) {
            this.batchDelay = 2000L;
        }
        return (T)this;
    }

    public long getBatchDelay() {
        return this.batchDelay;
    }

    public T setBatchDelay(long value) {
        if (this.isSynchronous) {
            value = 0L;
        }
        this.batchDelay = value;
        return (T)this;
    }

    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    public T setDiscardThreshold(int value) {
        this.discardThreshold = value;
        return (T)this;
    }

    public MessageQueue.DiscardAction getDiscardAction() {
        return this.discardAction;
    }

    public T setDiscardAction(MessageQueue.DiscardAction value) {
        this.discardAction = value;
        return (T)this;
    }

    public String getClientFactoryMethod() {
        return this.clientFactoryMethod;
    }

    public T setClientFactoryMethod(String value) {
        this.clientFactoryMethod = value;
        return (T)this;
    }

    public String getAssumedRole() {
        return this.assumedRole;
    }

    public T setAssumedRole(String value) {
        this.assumedRole = value;
        return (T)this;
    }

    public String getClientRegion() {
        return this.clientRegion;
    }

    public T setClientRegion(String value) {
        this.clientRegion = value;
        return (T)this;
    }

    public String getClientEndpoint() {
        return this.clientEndpoint;
    }

    public T setClientEndpoint(String value) {
        this.clientEndpoint = value;
        return (T)this;
    }

    public boolean getUseShutdownHook() {
        return this.useShutdownHook;
    }

    public T setUseShutdownHook(boolean value) {
        this.useShutdownHook = value;
        return (T)this;
    }

    public long getInitializationTimeout() {
        return this.initializationTimeout;
    }

    public T setInitializationTimeout(long value) {
        this.initializationTimeout = value;
        return (T)this;
    }

    public boolean getEnableBatchLogging() {
        return this.enableBatchLogging;
    }

    public T setEnableBatchLogging(boolean value) {
        this.enableBatchLogging = value;
        return (T)this;
    }
}

