/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.common.util;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class RetryManager2 {
    private String operationName;
    private Duration initialDuration;
    private boolean isExponential;
    private boolean throwOnTimeout;
    private Consumer<RuntimeException> uncaughtHandler = new Consumer<RuntimeException>(){

        @Override
        public void accept(RuntimeException ex) {
            throw ex;
        }
    };

    public RetryManager2(String operationName, Duration initialDuration, boolean isExponential, boolean throwOnTimeout) {
        this.operationName = operationName;
        this.initialDuration = initialDuration;
        this.isExponential = isExponential;
        this.throwOnTimeout = throwOnTimeout;
    }

    public RetryManager2(String operationName, Duration initialDuration) {
        this(operationName, initialDuration, true, true);
    }

    public <T> T invoke(Instant timeoutAt, Supplier<T> supplier, Consumer<RuntimeException> exceptionHandler) {
        long currentSleep = this.initialDuration.toMillis();
        long timeoutAtMillis = timeoutAt.toEpochMilli();
        while (System.currentTimeMillis() < timeoutAtMillis) {
            try {
                T result = supplier.get();
                if (result != null) {
                    return result;
                }
            }
            catch (RuntimeException ex) {
                exceptionHandler.accept(ex);
            }
            RetryManager2.sleepQuietly(currentSleep);
            if (!this.isExponential) continue;
            currentSleep *= 2L;
        }
        if (this.throwOnTimeout) {
            throw new TimeoutException(this.operationName, timeoutAt, Instant.now());
        }
        return null;
    }

    public <T> T invoke(Instant timeoutAt, Supplier<T> supplier) {
        return this.invoke(timeoutAt, supplier, this.uncaughtHandler);
    }

    public <T> T invoke(Duration timeout, Supplier<T> supplier, Consumer<RuntimeException> exceptionHandler) {
        return this.invoke(Instant.now().plus(timeout), supplier, exceptionHandler);
    }

    public <T> T invoke(Duration timeout, Supplier<T> supplier) {
        return this.invoke(Instant.now().plus(timeout), supplier, this.uncaughtHandler);
    }

    public static boolean sleepQuietly(long duration) {
        try {
            Thread.sleep(duration);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public static class TimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private String operation;
        private Instant expectedTimeout;
        private Instant actualTimeout;

        public TimeoutException(String operation, Instant expectedTimeout, Instant actualTimeout) {
            this.operation = operation;
            this.expectedTimeout = expectedTimeout;
            this.actualTimeout = actualTimeout;
        }

        @Override
        public String getMessage() {
            return this.operation + " did not complete by " + this.expectedTimeout + " (now " + this.actualTimeout + ")";
        }

        public String getOperation() {
            return this.operation;
        }

        public Instant getExpectedTimeout() {
            return this.expectedTimeout;
        }

        public Instant getActualTimeout() {
            return this.actualTimeout;
        }
    }
}

