/*
 * Decompiled with CFR 0.152.
 */
package com.kelveden.karma;

import com.kelveden.karma.KarmaUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.fusesource.jansi.AnsiConsole;

@Mojo(name="start", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public class StartMojo
extends AbstractMojo {
    static final String defaultKarmaExe = "karma";
    private static final String KARMA_JUNIT_REPORTER = "junit";
    private static final String KARMA_JUNIT_REPORTER_PLUGIN = "karma-junit-reporter";
    @Parameter(defaultValue="${project.build.directory}/karma-reports", required=false)
    private File reportsDirectory;
    @Parameter(defaultValue="${basedir}/karma.conf.js", property="configFile", required=true)
    private File configFile;
    @Parameter(property="junitReportFile", required=false)
    private File junitReportFile;
    @Parameter(defaultValue="${basedir}", property="nodeModulePath", required=false)
    private File workingDirectory;
    @Parameter(property="browsers", required=false)
    private String browsers;
    @Parameter(property="autoWatch", required=false)
    private Boolean autoWatch;
    @Parameter(property="reporters", required=false)
    private String reporters;
    @Parameter(property="captureTimeout", required=false)
    private Integer captureTimeout;
    @Parameter(property="singleRun", required=false, defaultValue="true")
    private Boolean singleRun;
    @Parameter(property="reportSlowerThan", required=false)
    private Integer reportSlowerThan;
    @Parameter(property="colors", required=false)
    private Boolean colors;
    @Parameter(property="skipKarma", required=false, defaultValue="false")
    private Boolean skipKarma;
    @Parameter(property="skipTests", required=false, defaultValue="false")
    private Boolean skipTests;
    @Parameter(property="karmaFailureIgnore", required=false, defaultValue="false")
    private Boolean karmaFailureIgnore;
    @Parameter(property="karmaExecutable", required=false, defaultValue="karma")
    private String karmaExecutable;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipKarma.booleanValue() || this.skipTests.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping Karma test suite execution.");
            return;
        }
        this.preExecution();
        Process karma = this.createKarmaProcess();
        if (!this.executeKarma(karma) && this.singleRun.booleanValue()) {
            if (this.karmaFailureIgnore.booleanValue()) {
                this.getLog().warn((CharSequence)"There were Karma test failures.");
            } else {
                this.postExecution();
                throw new MojoFailureException("There were Karma test failures.");
            }
        }
        this.postExecution();
        AnsiConsole.out.flush();
    }

    private void preExecution() throws MojoFailureException {
        String karmaConfiguration;
        if (!this.configFile.exists()) {
            throw new MojoFailureException("Cannot read the supplied Karma configuration file because it does not exist: " + this.configFile.getAbsolutePath());
        }
        try {
            karmaConfiguration = FileUtils.readFileToString((File)this.configFile);
        }
        catch (IOException e) {
            throw new MojoFailureException("Cannot read the supplied Karma configuration at " + this.configFile.getAbsolutePath() + ". Do you have read permission?");
        }
        if (!this.reportsDirectory.exists() && !this.reportsDirectory.mkdirs()) {
            throw new MojoFailureException("Cannot create reporting directory " + this.reportsDirectory.getAbsolutePath());
        }
        if (!this.reportsDirectory.isDirectory() || !this.reportsDirectory.canWrite()) {
            throw new MojoFailureException("Cannot write to the supplied reporting directory " + this.reportsDirectory.getAbsolutePath());
        }
        if (this.junitReportFile != null) {
            this.getLog().info((CharSequence)"Enabling Karma's junit reporter plugin (karma-junit-reporter)");
            if (this.reporters == null) {
                if (!karmaConfiguration.contains("'junit'")) {
                    this.reporters = KARMA_JUNIT_REPORTER;
                }
            } else if (!this.reporters.contains(KARMA_JUNIT_REPORTER)) {
                this.reporters = this.reporters + ",junit";
            }
            if (!karmaConfiguration.contains("'karma-junit-reporter'")) {
                this.getLog().warn((CharSequence)"Could not find the karma-junit-reporter plugin in the supplied configuration file. Test results may be unavailable or incorrect!");
            }
        }
    }

    private Process createKarmaProcess() throws MojoExecutionException {
        ProcessBuilder builder = KarmaUtils.getKarmaProcessBuilder(this.karmaExecutable, this.configFile.getAbsolutePath());
        if (this.workingDirectory != null) {
            builder.directory(this.workingDirectory);
        }
        List<String> command = builder.command();
        command.addAll(KarmaUtils.valueToKarmaArgument(this.browsers, "--browsers"));
        command.addAll(KarmaUtils.valueToKarmaArgument(this.reporters, "--reporters"));
        command.addAll(KarmaUtils.valueToKarmaArgument(this.singleRun, "--single-run", "--no-single-run"));
        command.addAll(KarmaUtils.valueToKarmaArgument(this.autoWatch, "--auto-watch", "--no-auto-watch"));
        command.addAll(KarmaUtils.valueToKarmaArgument(this.captureTimeout, "--capture-timeout"));
        command.addAll(KarmaUtils.valueToKarmaArgument(this.reportSlowerThan, "--report-slower-than"));
        command.addAll(KarmaUtils.valueToKarmaArgument(this.colors, "--colors"));
        builder.redirectErrorStream(true);
        try {
            this.getLog().info((CharSequence)"Executing Karma Test Suite ...");
            this.getLog().info((CharSequence)StringUtils.join(command.iterator(), (String)" "));
            return builder.start();
        }
        catch (IOException e) {
            this.resetAnsiConsole();
            throw new MojoExecutionException("There was an error executing Karma.", (Exception)e);
        }
    }

    private boolean executeKarma(Process karma) throws MojoExecutionException {
        BufferedReader karmaOutputReader = null;
        try {
            karmaOutputReader = this.createKarmaOutputReader(karma);
            String line22 = karmaOutputReader.readLine();
            while (line22 != null) {
                AnsiConsole.out.print(line22);
                AnsiConsole.out.println("\u001b[0m ");
                line22 = karmaOutputReader.readLine();
            }
            this.resetAnsiConsole();
            boolean line22 = karma.waitFor() == 0;
            return line22;
        }
        catch (IOException e) {
            this.resetAnsiConsole();
            throw new MojoExecutionException("There was an error reading the output from Karma.", (Exception)e);
        }
        catch (InterruptedException e) {
            this.resetAnsiConsole();
            throw new MojoExecutionException("The Karma process was interrupted.", (Exception)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)karmaOutputReader);
        }
    }

    private BufferedReader createKarmaOutputReader(Process p) {
        return new BufferedReader(new InputStreamReader(p.getInputStream()));
    }

    private void resetAnsiConsole() {
        AnsiConsole.out.println("\u001b[0m ");
    }

    private void postExecution() {
        if (this.junitReportFile != null) {
            if (!this.junitReportFile.exists() || !this.junitReportFile.isFile()) {
                this.getLog().warn((CharSequence)("Karma's junit reporter was enabled but no results were found at " + this.junitReportFile.getAbsolutePath() + ". Is the reporter plugin (" + KARMA_JUNIT_REPORTER_PLUGIN + ") installed correctly and enabled in the Karma configuration file?"));
            } else {
                try {
                    FileUtils.copyFile((File)this.junitReportFile, (File)new File(this.reportsDirectory, this.junitReportFile.getName()));
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Could not copy Karma's junit report to " + this.reportsDirectory.getAbsolutePath()));
                }
            }
        }
    }
}

