/*
 * Decompiled with CFR 0.152.
 */
package com.beust.klaxon;

import com.beust.klaxon.Token;
import com.beust.klaxon.Type;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007H\u0002J\b\u0010&\u001a\u00020$H\u0002J\u000e\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007J\u000e\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007J\b\u0010)\u001a\u00020\u0007H\u0002J\u0006\u0010*\u001a\u00020\u0010J\b\u0010+\u001a\u00020\u0007H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\tR\u0019\u0010\u0015\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006,"}, d2={"Lcom/beust/klaxon/Lexer;", "", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "BOOLEAN_LETTERS", "", "", "getBOOLEAN_LETTERS", "()Ljava/util/Set;", "DOUBLE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getDOUBLE", "()Ljava/util/regex/Pattern;", "EOF", "Lcom/beust/klaxon/Token;", "getEOF", "()Lcom/beust/klaxon/Token;", "NULL_LETTERS", "getNULL_LETTERS", "NUMERIC", "getNUMERIC", "bytes", "", "getBytes", "()[B", "index", "", "getIndex", "()I", "setIndex", "(I)V", "getInputStream", "()Ljava/io/InputStream;", "isBooleanLetter", "", "c", "isDone", "isSpace", "isValueLetter", "nextChar", "nextToken", "peekChar", "project-klaxon"})
@KotlinClass(version={1, 1, 0}, data={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007H\u0002J\b\u0010&\u001a\u00020$H\u0002J\u000e\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007J\u000e\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007J\b\u0010)\u001a\u00020\u0007H\u0002J\u0006\u0010*\u001a\u00020\u0010J\b\u0010+\u001a\u00020\u0007H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\tR\u0019\u0010\u0015\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006,"}, strings={"Lcom/beust/klaxon/Lexer;", "", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "BOOLEAN_LETTERS", "", "", "getBOOLEAN_LETTERS", "()Ljava/util/Set;", "DOUBLE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getDOUBLE", "()Ljava/util/regex/Pattern;", "EOF", "Lcom/beust/klaxon/Token;", "getEOF", "()Lcom/beust/klaxon/Token;", "NULL_LETTERS", "getNULL_LETTERS", "NUMERIC", "getNUMERIC", "bytes", "", "getBytes", "()[B", "index", "", "getIndex", "()I", "setIndex", "(I)V", "getInputStream", "()Ljava/io/InputStream;", "isBooleanLetter", "", "c", "isDone", "isSpace", "isValueLetter", "nextChar", "nextToken", "peekChar", "project-klaxon"})
public final class Lexer {
    @NotNull
    private final byte[] bytes;
    @NotNull
    private final Token EOF;
    private int index;
    private final Pattern NUMERIC;
    private final Pattern DOUBLE;
    @NotNull
    private final Set<Character> BOOLEAN_LETTERS;
    @NotNull
    private final Set<Character> NULL_LETTERS;
    @NotNull
    private final InputStream inputStream;

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    @NotNull
    public final Token getEOF() {
        return this.EOF;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final Pattern getNUMERIC() {
        return this.NUMERIC;
    }

    public final Pattern getDOUBLE() {
        return this.DOUBLE;
    }

    public final boolean isSpace(char c) {
        return c == ' ' || c == '\r' || c == '\n' || c == '\t';
    }

    private final char nextChar() {
        return (char)this.bytes[this.index++];
    }

    private final char peekChar() {
        return (char)this.bytes[this.index];
    }

    private final boolean isDone() {
        return this.index >= this.bytes.length;
    }

    @NotNull
    public final Set<Character> getBOOLEAN_LETTERS() {
        return this.BOOLEAN_LETTERS;
    }

    private final boolean isBooleanLetter(char c) {
        return this.BOOLEAN_LETTERS.contains(Character.valueOf(Character.toLowerCase(c)));
    }

    @NotNull
    public final Set<Character> getNULL_LETTERS() {
        return this.NULL_LETTERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValueLetter(char c) {
        if (c == '-') return true;
        if (c == '+') return true;
        if (c == '.') return true;
        char $receiver$iv = c;
        if (Character.isDigit($receiver$iv)) return true;
        if (this.isBooleanLetter(c)) return true;
        if (!this.NULL_LETTERS.contains(Character.valueOf(c))) return false;
        return true;
    }

    @NotNull
    public final Token nextToken() {
        Type tokenType;
        if (this.isDone()) {
            return this.EOF;
        }
        char c = this.nextChar();
        StringBuilder currentValue = new StringBuilder();
        Object jsonValue = null;
        while (!this.isDone() && this.isSpace(c)) {
            c = this.nextChar();
        }
        if ('\"' == c) {
            tokenType = Type.VALUE;
            block19: do {
                if (this.isDone()) {
                    throw (Throwable)new RuntimeException("Unterminated string");
                }
                c = this.nextChar();
                block2 : switch (c) {
                    case '\\': {
                        if (this.isDone()) {
                            throw (Throwable)new RuntimeException("Unterminated string");
                        }
                        c = this.nextChar();
                        switch (c) {
                            case '\\': {
                                currentValue.append("\\");
                                break block2;
                            }
                            case '/': {
                                currentValue.append("/");
                                break block2;
                            }
                            case 'b': {
                                currentValue.append("\b");
                                break block2;
                            }
                            case 'f': {
                                currentValue.append("\f");
                                break block2;
                            }
                            case 'n': {
                                currentValue.append("\n");
                                break block2;
                            }
                            case 'r': {
                                currentValue.append("\r");
                                break block2;
                            }
                            case 't': {
                                currentValue.append("\t");
                                break block2;
                            }
                            case 'u': {
                                StringBuilder unicodeChar = new StringBuilder(4).append(this.nextChar()).append(this.nextChar()).append(this.nextChar()).append(this.nextChar());
                                int intValue = Integer.parseInt(unicodeChar.toString(), 16);
                                currentValue.append((char)intValue);
                                break block2;
                            }
                        }
                        currentValue.append(c);
                        break;
                    }
                    case '\"': {
                        break block19;
                    }
                    default: {
                        currentValue.append(c);
                    }
                }
            } while (true);
            jsonValue = currentValue.toString();
        } else if ('{' == c) {
            tokenType = Type.LEFT_BRACE;
        } else if ('}' == c) {
            tokenType = Type.RIGHT_BRACE;
        } else if ('[' == c) {
            tokenType = Type.LEFT_BRACKET;
        } else if (']' == c) {
            tokenType = Type.RIGHT_BRACKET;
        } else if (':' == c) {
            tokenType = Type.COLON;
        } else if (',' == c) {
            tokenType = Type.COMMA;
        } else if (!this.isDone()) {
            String v;
            while (this.isValueLetter(c)) {
                currentValue.append(c);
                if (!this.isValueLetter(this.peekChar())) break;
                c = this.nextChar();
            }
            if (this.NUMERIC.matcher(v = currentValue.toString()).matches()) {
                try {
                    jsonValue = Integer.parseInt(v);
                }
                catch (NumberFormatException e) {
                    try {
                        jsonValue = Long.parseLong(v);
                    }
                    catch (NumberFormatException e2) {
                        jsonValue = new BigInteger(v);
                    }
                }
            } else if (this.DOUBLE.matcher(v).matches()) {
                jsonValue = Double.parseDouble(v);
            } else {
                String $receiver$iv;
                String e = v;
                String string2 = "true";
                void v0 = $receiver$iv;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)v0).toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
                String string4 = string3;
                if (string2.equals(string4)) {
                    jsonValue = true;
                } else {
                    $receiver$iv = v;
                    string2 = "false";
                    String string5 = $receiver$iv;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.String).toLowerCase()");
                    string4 = string6;
                    if (string2.equals(string4)) {
                        jsonValue = false;
                    } else if (Intrinsics.areEqual(v, "null")) {
                        jsonValue = null;
                    } else {
                        throw (Throwable)new RuntimeException("Unexpected character at position " + this.index + (": '" + c + " (" + c + ")'"));
                    }
                }
            }
            tokenType = Type.VALUE;
        } else {
            tokenType = Type.EOF;
        }
        return new Token(tokenType, jsonValue);
    }

    @NotNull
    public final InputStream getInputStream() {
        return this.inputStream;
    }

    public Lexer(@NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull(inputStream, "inputStream");
        this.inputStream = inputStream;
        this.bytes = ByteStreamsKt.readBytes$default(this.inputStream, 0, 1, null);
        this.EOF = new Token(Type.EOF, null);
        this.NUMERIC = Pattern.compile("[-]?[0-9]+");
        this.DOUBLE = Pattern.compile(this.NUMERIC.toString() + "((\\.[0-9]+)?([eE][-+]?[0-9]+)?)");
        this.BOOLEAN_LETTERS = StringsKt.toSet("falsetrue");
        this.NULL_LETTERS = StringsKt.toSet("null");
    }
}

