/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.call;

import com.beust.klaxon.DSLKt;
import com.beust.klaxon.JsonArray;
import com.beust.klaxon.JsonObject;
import com.beust.klaxon.LookupKt;
import com.beust.klaxon.Parser;
import com.kennycason.call.Version;
import com.kennycason.call.commands.CommandRunner;
import com.kennycason.call.commands.internal.StoredCommand;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.ConstantsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0013\u001a\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\u0012J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u001a\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fJ\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lcom/kennycason/call/CommandLibrary;", "", "()V", "COMMAND_LIBRARY_FILE", "Ljava/io/File;", "getCOMMAND_LIBRARY_FILE", "()Ljava/io/File;", "COMMAND_LIBRARY_FILE_BKP", "getCOMMAND_LIBRARY_FILE_BKP", "add", "", "command", "", "definition", "all", "", "Lcom/kennycason/call/commands/internal/StoredCommand;", "buildDefaultLibraryFile", "Lcom/beust/klaxon/JsonObject;", "libraryToJson", "library", "parse", "", "libraryJson", "readLibraryJson", "remove", "save", "validateCommands", "commandObject", "call"})
public final class CommandLibrary {
    @NotNull
    private final File COMMAND_LIBRARY_FILE = new File(System.getProperty("user.home"), ".call.library.json");
    @NotNull
    private final File COMMAND_LIBRARY_FILE_BKP = new File(System.getProperty("user.home"), ".call.library.json.bkp");

    @NotNull
    public final File getCOMMAND_LIBRARY_FILE() {
        return this.COMMAND_LIBRARY_FILE;
    }

    @NotNull
    public final File getCOMMAND_LIBRARY_FILE_BKP() {
        return this.COMMAND_LIBRARY_FILE_BKP;
    }

    @NotNull
    public final Map<String, StoredCommand> all() {
        return this.parse(this.readLibraryJson());
    }

    public final void add(@NotNull String command, @NotNull String definition) {
        Intrinsics.checkParameterIsNotNull(command, "command");
        Intrinsics.checkParameterIsNotNull(definition, "definition");
        Map<String, StoredCommand> library = this.parse(this.readLibraryJson());
        Object object = library;
        Object object2 = object;
        Map<String, StoredCommand> map = object2;
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (map.containsKey(command)) {
            object = "Warning, overwriting existing command.";
            System.out.println(object);
        }
        if (new CommandRunner().isInternalCommand(command)) {
            throw (Throwable)new RuntimeException("Command [" + command + "] is a reserved command name");
        }
        object = library;
        object2 = new StoredCommand(definition);
        object.put((String)command, (StoredCommand)object2);
        this.save(library);
        object = "command [" + command + "] added.";
        System.out.println(object);
        object = "\t" + "\t" + definition;
        System.out.println(object);
    }

    public final void remove(@NotNull String command) {
        Intrinsics.checkParameterIsNotNull(command, "command");
        Map<String, StoredCommand> library = this.parse(this.readLibraryJson());
        Object object = library;
        Map<String, StoredCommand> map = object;
        Map<String, StoredCommand> map2 = map;
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (!map2.containsKey(command)) {
            object = "Warning, command [" + command + "] does not exist.";
            System.out.println(object);
        }
        library.remove(command);
        this.save(library);
        object = "command [" + command + "] removed.";
        System.out.println(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull Map<String, StoredCommand> library) {
        PrintWriter printWriter;
        Intrinsics.checkParameterIsNotNull(library, "library");
        this.COMMAND_LIBRARY_FILE.renameTo(this.COMMAND_LIBRARY_FILE_BKP);
        this.COMMAND_LIBRARY_FILE.createNewFile();
        Object object = this.COMMAND_LIBRARY_FILE;
        Charset charset = null;
        boolean bl = true;
        File file = null;
        if (file != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: printWriter");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        file = object;
        int n = 0;
        int n2 = 2;
        Object object2 = null;
        PrintWriter printWriter2 = printWriter;
        PrintWriter printWriter3 = printWriter;
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bufferedWriter");
        }
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n2 & 2) != 0) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        object2 = file;
        Object object3 = object2;
        object3 = new FileOutputStream((File)object3);
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        BufferedWriter bufferedWriter = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
        printWriter2(bufferedWriter);
        object = printWriter3;
        boolean bl2 = false;
        try {
            PrintWriter out = (PrintWriter)object;
            out.write(this.libraryToJson(library));
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            bl2 = true;
            try {
                object.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl2) {
                object.close();
            }
        }
    }

    @NotNull
    public final Map<String, StoredCommand> parse(@NotNull JsonObject libraryJson) {
        Intrinsics.checkParameterIsNotNull(libraryJson, "libraryJson");
        Map map = libraryJson;
        String string2 = "commands";
        Map map2 = map;
        Map map3 = map2;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (!map3.containsKey(string2)) {
            throw (Throwable)new RuntimeException("Field 'commands' was not present in library file!");
        }
        Map<String, StoredCommand> commands = MapsKt.mutableMapOf(new Pair[0]);
        JsonArray jsonArray = LookupKt.array(libraryJson, "commands");
        if (jsonArray == null) {
            Intrinsics.throwNpe();
        }
        Iterable $receiver$iv = jsonArray;
        for (Object element$iv : $receiver$iv) {
            String string3;
            JsonObject commandObject = (JsonObject)element$iv;
            this.validateCommands(commandObject);
            Map<String, StoredCommand> map4 = commands;
            if (LookupKt.string(commandObject, "command") == null) {
                Intrinsics.throwNpe();
            }
            String string4 = LookupKt.string(commandObject, "definition");
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            StoredCommand storedCommand = new StoredCommand(string4);
            map4.put(string3, storedCommand);
        }
        return commands;
    }

    /*
     * WARNING - void declaration
     */
    private final String libraryToJson(Map<String, StoredCommand> library) {
        void $receiver$iv;
        JsonObject libraryJson = DSLKt.JsonObject$default(null, 1, null);
        libraryJson.put("version", (Object)new Version().getVersion());
        ArrayList<JsonObject> commands = new ArrayList<JsonObject>();
        Map map = library;
        String string2 = $receiver$iv;
        Object object = string2.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry command = element$iv = object.next();
            JsonObject commandJson = DSLKt.JsonObject$default(null, 1, null);
            Map map2 = commandJson;
            String string3 = "command";
            Object object2 = command.getKey();
            map2.put(string3, object2);
            map2 = commandJson;
            string3 = "definition";
            object2 = ((StoredCommand)command.getValue()).getDefinition();
            map2.put(string3, object2);
            commands.add(commandJson);
        }
        map = libraryJson;
        string2 = "commands";
        object = new JsonArray((List)commands);
        map.put(string2, object);
        return libraryJson.toJsonString(true);
    }

    private final void validateCommands(JsonObject commandObject) {
        if (!commandObject.containsKey((Object)"command")) {
            throw (Throwable)new RuntimeException("Field 'command' was not present in library file!");
        }
        if (!commandObject.containsKey((Object)"definition")) {
            throw (Throwable)new RuntimeException("Field 'definition' was not present in library file!");
        }
    }

    private final JsonObject readLibraryJson() {
        if (!this.COMMAND_LIBRARY_FILE.exists()) {
            return this.buildDefaultLibraryFile();
        }
        try {
            File file = this.COMMAND_LIBRARY_FILE;
            Parser parser = new Parser();
            FileInputStream fileInputStream = new FileInputStream(file);
            Object object = parser.parse(fileInputStream);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.beust.klaxon.JsonObject");
            }
            return (JsonObject)object;
        }
        catch (RuntimeException e) {
            throw (Throwable)new RuntimeException("Encountered error when reading [" + this.COMMAND_LIBRARY_FILE.getAbsoluteFile() + "] file: " + e.getMessage() + "\nReturning empty library");
        }
    }

    private final JsonObject buildDefaultLibraryFile() {
        String string2 = "No Library found, generating new one, [" + this.COMMAND_LIBRARY_FILE.getAbsoluteFile() + "]";
        System.out.println((Object)string2);
        String libraryTemplate = "com/kennycason/call/library/template.json";
        Parser parser = new Parser();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(libraryTemplate);
        Intrinsics.checkExpressionValueIsNotNull(inputStream, "Thread.currentThread()\n \u2026AsStream(libraryTemplate)");
        Object object = parser.parse(inputStream);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.beust.klaxon.JsonObject");
        }
        return (JsonObject)object;
    }
}

