/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.call.commands;

import com.kennycason.call.CommandLibrary;
import com.kennycason.call.commands.internal.Add;
import com.kennycason.call.commands.internal.Help;
import com.kennycason.call.commands.internal.InternalCommand;
import com.kennycason.call.commands.internal.Library;
import com.kennycason.call.commands.internal.PrintVersion;
import com.kennycason.call.commands.internal.Remove;
import com.kennycason.call.commands.internal.StoredCommand;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J*\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u0004H\u0002J$\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u0004H\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/kennycason/call/commands/CommandRunner;", "", "()V", "internalCommands", "", "", "Lcom/kennycason/call/commands/internal/InternalCommand;", "getInternalCommands", "()Ljava/util/Map;", "library", "Lcom/kennycason/call/CommandLibrary;", "getLibrary", "()Lcom/kennycason/call/CommandLibrary;", "isInternalCommand", "", "command", "run", "", "commands", "", "runExternalCommands", "commandAndArguments", "Lcom/kennycason/call/commands/internal/StoredCommand;", "validateCommand", "call"})
public final class CommandRunner {
    @NotNull
    private final CommandLibrary library = new CommandLibrary();
    @NotNull
    private final Map<String, InternalCommand> internalCommands = MapsKt.mapOf(new Pair<String, Add>("add", new Add()), new Pair<String, Help>("help", new Help()), new Pair<String, Library>("list", new Library()), new Pair<String, PrintVersion>("version", new PrintVersion()), new Pair<String, Remove>("remove", new Remove()));

    @NotNull
    public final CommandLibrary getLibrary() {
        return this.library;
    }

    @NotNull
    public final Map<String, InternalCommand> getInternalCommands() {
        return this.internalCommands;
    }

    public final void run(@NotNull List<String> commands) {
        Intrinsics.checkParameterIsNotNull(commands, "commands");
        if (commands.isEmpty()) {
            String string2 = "No command specified!\n";
            System.out.println((Object)string2);
            InternalCommand internalCommand = this.internalCommands.get("help");
            if (internalCommand == null) {
                Intrinsics.throwNpe();
            }
            internalCommand.run(CollectionsKt.<String>emptyList());
            return;
        }
        if (this.internalCommands.containsKey(CollectionsKt.first(commands))) {
            InternalCommand internalCommand = this.internalCommands.get(CollectionsKt.first(commands));
            if (internalCommand == null) {
                Intrinsics.throwNpe();
            }
            internalCommand.run(commands);
            return;
        }
        Map<String, StoredCommand> library = this.library.all();
        this.runExternalCommands(commands, library);
    }

    public final boolean isInternalCommand(@NotNull String command) {
        Intrinsics.checkParameterIsNotNull(command, "command");
        Map<String, InternalCommand> map = this.internalCommands;
        Map<String, InternalCommand> map2 = map;
        Map<String, InternalCommand> map3 = map2;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map3.containsKey(command);
    }

    private final void runExternalCommands(List<String> commandAndArguments, Map<String, StoredCommand> library) {
        String command = CollectionsKt.first(commandAndArguments);
        List<String> arguments = commandAndArguments.size() == 1 ? CollectionsKt.emptyList() : commandAndArguments.subList(1, commandAndArguments.size());
        this.validateCommand(command, library);
        StoredCommand storedCommand = library.get(command);
        if (storedCommand == null) {
            Intrinsics.throwNpe();
        }
        storedCommand.run(arguments);
    }

    private final void validateCommand(String command, Map<String, StoredCommand> library) {
        if (!library.containsKey(command)) {
            String string2 = "Command [" + command + "] not found, try " + "\"" + "list" + "\"" + " or " + "\"" + "help" + "\"" + " to see which commands are available.";
            System.out.println((Object)string2);
            int n = 1;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }
}

