/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.call.commands.internal;

import com.beust.klaxon.JsonObject;
import com.beust.klaxon.Parser;
import com.kennycason.call.CommandLibrary;
import com.kennycason.call.commands.internal.InternalCommand;
import com.kennycason.call.commands.internal.StoredCommand;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u000f\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/kennycason/call/commands/internal/Add;", "Lcom/kennycason/call/commands/internal/InternalCommand;", "()V", "addCommandsForResource", "", "resource", "", "addSingleCommand", "command", "definition", "isUrlValid", "", "url", "loadResource", "Lcom/beust/klaxon/JsonObject;", "run", "commands", "", "sanitize", "validate", "call"})
public final class Add
implements InternalCommand {
    @Override
    public void run(@NotNull List<String> commands) {
        Intrinsics.checkParameterIsNotNull(commands, "commands");
        if (commands.size() == 2) {
            this.addCommandsForResource(commands.get(1));
        } else if (commands.size() == 3) {
            String string2 = commands.get(1);
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String command = string2;
            String string3 = this.sanitize(commands.get(2));
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            String definition = string3;
            this.addSingleCommand(command, definition);
        } else {
            throw (Throwable)new RuntimeException("Must provide a command name and definition. Found " + (commands.size() - 1) + " arguments. " + "Be sure to add quotes around the command definition if definition contains spaces or multiple commands to call.");
        }
    }

    private final void addSingleCommand(String command, String definition) {
        this.validate(command, definition);
        new CommandLibrary().add(command, definition);
    }

    /*
     * WARNING - void declaration
     */
    private final void addCommandsForResource(String resource) {
        void $receiver$iv;
        Map<String, StoredCommand> commandsToImport;
        CommandLibrary commandLibrary = new CommandLibrary();
        Map<String, StoredCommand> map = commandsToImport = commandLibrary.parse(this.loadResource(resource));
        void var5_5 = $receiver$iv;
        Iterator iterator2 = var5_5.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry command = element$iv = iterator2.next();
            String string2 = "Importing command: " + (String)command.getKey() + "\n\t\t" + ((StoredCommand)command.getValue()).getDefinition();
            System.out.println((Object)string2);
            this.addSingleCommand((String)command.getKey(), ((StoredCommand)command.getValue()).getDefinition());
        }
    }

    private final JsonObject loadResource(String resource) {
        if (this.isUrlValid(resource)) {
            String string2 = "Importing library from file: " + resource;
            System.out.println((Object)string2);
            Parser parser = new Parser();
            InputStream inputStream = new URL(resource).openStream();
            Intrinsics.checkExpressionValueIsNotNull(inputStream, "URL(resource).openStream()");
            Object object = parser.parse(inputStream);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.beust.klaxon.JsonObject");
            }
            return (JsonObject)object;
        }
        if (new File(resource).exists()) {
            String string3 = "Importing library from file: " + resource;
            System.out.println((Object)string3);
            Object object = new Parser().parse(resource);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.beust.klaxon.JsonObject");
            }
            return (JsonObject)object;
        }
        throw (Throwable)new RuntimeException("Library file or url could not be found!");
    }

    private final void validate(String command, String definition) {
        if (command.length() == 0) {
            throw (Throwable)new RuntimeException("Command length can not be zero");
        }
        if (definition.length() == 0) {
            throw (Throwable)new RuntimeException("Command definition length can not be zero");
        }
    }

    private final String sanitize(String definition) {
        if (definition.charAt(0) == '\"' && definition.charAt(StringsKt.getLastIndex(definition)) == '\"' || definition.charAt(0) == '\'' && definition.charAt(StringsKt.getLastIndex(definition)) == '\'') {
            String string2 = definition;
            int n = 1;
            int n2 = StringsKt.getLastIndex(definition) - 1;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string4;
        }
        return definition;
    }

    private final boolean isUrlValid(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

