/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.image;

import java.util.Random;

public class AngleGenerator {
    private static final Random RANDOM = new Random();
    private final int steps;
    private final double[] thetas;
    private int next;

    public AngleGenerator() {
        this.steps = 3;
        this.thetas = this.calculateThetas(-90.0, 90.0);
    }

    public AngleGenerator(int degrees) {
        this.steps = 1;
        this.thetas = new double[]{Math.toRadians(degrees)};
    }

    public AngleGenerator(double fromDegrees, double toDegrees, int steps) {
        this.steps = steps;
        this.thetas = this.calculateThetas(fromDegrees, toDegrees);
    }

    public AngleGenerator(double[] degrees) {
        this.thetas = degrees;
        this.steps = degrees.length;
    }

    public double next() {
        return this.thetas[this.next++ % this.steps];
    }

    public double randomNext() {
        return this.thetas[RANDOM.nextInt(this.steps)];
    }

    private double[] calculateThetas(double to, double from) {
        double stepSize = (to - from) / (double)(this.steps - 1);
        double[] thetas = new double[this.steps];
        for (int i = 0; i < this.steps; ++i) {
            thetas[i] = Math.toRadians(from + (double)i * stepSize);
        }
        return thetas;
    }
}

