/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo;

import com.kennycason.kumo.CollisionMode;
import com.kennycason.kumo.Word;
import com.kennycason.kumo.WordCloud;
import com.kennycason.kumo.WordFrequency;
import com.kennycason.kumo.bg.Background;
import com.kennycason.kumo.exception.KumoException;
import com.kennycason.kumo.font.KumoFont;
import com.kennycason.kumo.font.scale.FontScalar;
import com.kennycason.kumo.image.AngleGenerator;
import com.kennycason.kumo.palette.ColorPalette;
import com.kennycason.kumo.wordstart.WordStartStrategy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class LayeredWordCloud {
    private static final Logger LOGGER = Logger.getLogger(LayeredWordCloud.class);
    private final Dimension dimension;
    private final List<WordCloud> wordClouds = new ArrayList<WordCloud>();
    private Color backgroundColor = Color.BLACK;

    public LayeredWordCloud(int layers, Dimension dimension, CollisionMode collisionMode) {
        this.dimension = dimension;
        for (int i = 0; i < layers; ++i) {
            WordCloud wordCloud = new WordCloud(dimension, collisionMode);
            wordCloud.setBackgroundColor(null);
            this.wordClouds.add(wordCloud);
        }
    }

    public void build(int layer, List<WordFrequency> wordFrequencies) {
        this.wordClouds.get(layer).build(wordFrequencies);
    }

    public void setPadding(int layer, int padding) {
        this.wordClouds.get(layer).setPadding(padding);
    }

    public void setColorPalette(int layer, ColorPalette colorPalette) {
        this.wordClouds.get(layer).setColorPalette(colorPalette);
    }

    public void setBackground(int layer, Background background) {
        this.wordClouds.get(layer).setBackground(background);
    }

    public void setFontScalar(int layer, FontScalar fontScalar) {
        this.wordClouds.get(layer).setFontScalar(fontScalar);
    }

    public void setFontOptions(int layer, KumoFont kumoFont) {
        this.wordClouds.get(layer).setKumoFont(kumoFont);
    }

    public void setAngleGenerator(int layer, AngleGenerator angleGenerator) {
        this.wordClouds.get(layer).setAngleGenerator(angleGenerator);
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.dimension.width, this.dimension.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.dimension.width, this.dimension.height);
        for (WordCloud wordCloud : this.wordClouds) {
            graphics.drawImage(wordCloud.getBufferedImage(), 0, 0, null);
        }
        return bufferedImage;
    }

    public WordCloud getCloudLayer(int layer) {
        return this.wordClouds.get(layer);
    }

    public WordCloud getAt(int layer) {
        return this.getCloudLayer(layer);
    }

    public Set<Word> getSkipped(int layer) {
        return this.wordClouds.get(layer).getSkipped();
    }

    public void writeToFile(String outputFileName) {
        String extension = "";
        int i = outputFileName.lastIndexOf(46);
        if (i > 0) {
            extension = outputFileName.substring(i + 1);
        }
        try {
            LOGGER.info((Object)("Saving Layered WordCloud to " + outputFileName));
            ImageIO.write((RenderedImage)this.getBufferedImage(), extension, new File(outputFileName));
        }
        catch (IOException e) {
            throw new KumoException(e);
        }
    }

    public void setStartScheme(int layer, WordStartStrategy scheme) {
        this.wordClouds.get(layer).setWordStartScheme(scheme);
    }

    public int getLayers() {
        return this.wordClouds.size();
    }
}

