/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo;

import com.kennycason.kumo.collide.Collidable;
import com.kennycason.kumo.collide.checkers.CollisionChecker;
import com.kennycason.kumo.image.CollisionRaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class Word
implements Collidable {
    private final CollisionChecker collisionChecker;
    private final String word;
    private final Color color;
    private Point position = new Point(0, 0);
    private BufferedImage bufferedImage;
    private CollisionRaster collisionRaster;

    public Word(String word, Color color, FontMetrics fontMetrics, CollisionChecker collisionChecker) {
        this.word = word;
        this.color = color;
        this.collisionChecker = collisionChecker;
        int maxDescent = fontMetrics.getMaxDescent();
        int maxAscent = fontMetrics.getMaxAscent();
        int width = fontMetrics.stringWidth(word);
        fontMetrics.getHeight();
        this.bufferedImage = new BufferedImage(width, maxAscent, 2);
        Graphics2D graphics = (Graphics2D)this.bufferedImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        graphics.setColor(color);
        graphics.setFont(fontMetrics.getFont());
        graphics.drawString(word, 0, maxAscent - maxDescent);
        this.collisionRaster = new CollisionRaster(this.bufferedImage);
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
        this.collisionRaster = new CollisionRaster(bufferedImage);
    }

    public String getWord() {
        return this.word;
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    @Override
    public Dimension getDimension() {
        return this.collisionRaster.getDimension();
    }

    @Override
    public CollisionRaster getCollisionRaster() {
        return this.collisionRaster;
    }

    @Override
    public boolean collide(Collidable collidable) {
        return this.collisionChecker.collide(this, collidable);
    }

    public void draw(CollisionRaster collisionRaster) {
        collisionRaster.mask(collisionRaster, this.position);
    }

    public String toString() {
        return "WordRectangle{word='" + this.word + '\'' + ", color=" + this.color + ", x=" + this.position.x + ", y=" + this.position.y + ", width=" + this.bufferedImage.getWidth() + ", height=" + this.bufferedImage.getHeight() + '}';
    }
}

