/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.nlp.normalize;

import com.kennycason.kumo.nlp.normalize.Normalizer;
import java.util.regex.Pattern;

public class CharacterStrippingNormalizer
implements Normalizer {
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("\\.|:|;|\\(|\\)|\"|,|\\?|,|!|<|>|/");
    private static final String DEFAULT_REPLACE_WITH = "";
    private final Pattern replacePattern;
    private final String replaceWith;

    public CharacterStrippingNormalizer() {
        this.replacePattern = DEFAULT_PATTERN;
        this.replaceWith = DEFAULT_REPLACE_WITH;
    }

    public CharacterStrippingNormalizer(Pattern replacePattern, String replaceWith) {
        this.replacePattern = replacePattern;
        this.replaceWith = replaceWith;
    }

    @Override
    public String normalize(String text) {
        return DEFAULT_PATTERN.matcher(text).replaceAll(DEFAULT_REPLACE_WITH);
    }
}

