/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.placement.tree;

import com.kennycason.kumo.Word;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class QuadTree {
    private Node root;

    public void add(Word word) {
        if (this.root == null) {
            this.root = new Node(word);
            return;
        }
        this.add(word, this.root);
    }

    private void add(Word word, Node node) {
        if (word.equals(node.word)) {
            return;
        }
        this.addByVertix(word, word.getPosition().x, word.getPosition().y, node);
        this.addByVertix(word, word.getPosition().x + word.getDimension().width, word.getPosition().y, node);
        this.addByVertix(word, word.getPosition().x, word.getPosition().y + word.getDimension().height, node);
        this.addByVertix(word, word.getPosition().x + word.getDimension().width, word.getPosition().y + word.getDimension().height, node);
    }

    private void addByVertix(Word word, int x2, int y2, Node node) {
        int x = node.word.getPosition().x;
        int y = node.word.getPosition().y;
        if (x2 < x) {
            if (y2 < y) {
                if (node.NW == null) {
                    node.NW = new Node(word);
                } else {
                    this.add(word, node.NW);
                }
            } else if (node.SW == null) {
                node.SW = new Node(word);
            } else {
                this.add(word, node.SW);
            }
        } else if (y2 < y) {
            if (node.NE == null) {
                node.NE = new Node(word);
            } else {
                this.add(word, node.NE);
            }
        } else if (node.SE == null) {
            node.SE = new Node(word);
        } else {
            this.add(word, node.SE);
        }
    }

    public Set<Word> getNearby(Word word) {
        if (this.root == null) {
            return Collections.emptySet();
        }
        HashSet<Word> nearby = new HashSet<Word>();
        this.getNearby(word, this.root, nearby);
        return nearby;
    }

    private void getNearby(Word word, Node node, Set<Word> nearby) {
        if (word.equals(node.word)) {
            return;
        }
        if (node.word == null) {
            return;
        }
        nearby.add(node.word);
        this.getNearbyByVertix(word, word.getPosition().x, word.getPosition().y, node, nearby);
        this.getNearbyByVertix(word, word.getPosition().x + word.getDimension().width, word.getPosition().y, node, nearby);
        this.getNearbyByVertix(word, word.getPosition().x, word.getPosition().y + word.getDimension().height, node, nearby);
        this.getNearbyByVertix(word, word.getPosition().x + word.getDimension().width, word.getPosition().y + word.getDimension().height, node, nearby);
    }

    private void getNearbyByVertix(Word word, int x2, int y2, Node node, Set<Word> nearby) {
        int x = node.word.getPosition().x;
        int y = node.word.getPosition().y;
        if (x2 < x) {
            if (y2 < y) {
                if (node.NW != null) {
                    this.getNearby(word, node.NW, nearby);
                }
            } else if (node.SW != null) {
                this.getNearby(word, node.SW, nearby);
            }
        } else if (y2 < y) {
            if (node.NE != null) {
                this.getNearby(word, node.NE, nearby);
            }
        } else if (node.SE != null) {
            this.getNearby(word, node.SE, nearby);
        }
    }

    private static class Node {
        public final Word word;
        public Node NE;
        public Node SE;
        public Node SW;
        public Node NW;

        private Node(Word word) {
            this.word = word;
        }
    }
}

