/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.jooq;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.kenshoo.jooq.DataTable;
import com.kenshoo.jooq.FieldAndValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jooq.DataType;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Record;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractKeys;
import org.jooq.impl.TableImpl;

public abstract class AbstractDataTable<T extends AbstractDataTable<T>>
extends TableImpl<Record>
implements DataTable {
    private final List<TableField<Record, ?>> primaryKeyFields = Lists.newArrayList();
    private final Supplier<UniqueKey<Record>> primaryKeySupplier = Suppliers.memoize((Supplier)new PrimaryKeySupplier());
    private final Multimap<Table<Record>, FieldsPair> foreignKeyFields = ArrayListMultimap.create();
    private final Supplier<List<ForeignKey<Record, ?>>> foreignKeysSupplier = Suppliers.memoize((Supplier)new ForeignKeysSupplier());
    private final Supplier<Identity<Record, ?>> identitySupplier = Suppliers.memoize((Supplier)new IdentitySupplier());
    private TableField<Record, ?> identityField;

    protected AbstractDataTable(String tableName) {
        super(tableName);
    }

    protected AbstractDataTable(T aliased, String alias) {
        super(alias, null, aliased);
    }

    protected AbstractDataTable(String tableName, Schema schema) {
        super(tableName, schema);
    }

    public abstract T as(String var1);

    protected final <FT> TableField<Record, FT> createPKField(String name, DataType<FT> type) {
        TableField field = this.createField(name, type);
        this.primaryKeyFields.add(field);
        if (type.identity()) {
            this.identityField = field;
        }
        return field;
    }

    protected final <FT> TableField<Record, FT> createPKAndFKField(String name, DataType<FT> type, TableField<Record, FT> referenceField) {
        TableField<Record, FT> field = this.createPKField(name, type);
        this.foreignKeyFields.put((Object)referenceField.getTable(), (Object)new FieldsPair(field, referenceField));
        return field;
    }

    protected final <FT> TableField<Record, FT> createFKField(String name, TableField<Record, FT> referenceField) {
        TableField field = this.createField(name, referenceField.getDataType().identity(false));
        this.foreignKeyFields.put((Object)referenceField.getTable(), (Object)new FieldsPair(field, referenceField));
        return field;
    }

    @Override
    public Collection<FieldAndValue<?>> getVirtualPartition() {
        return Collections.emptyList();
    }

    public UniqueKey<Record> getPrimaryKey() {
        return (UniqueKey)this.primaryKeySupplier.get();
    }

    public List<ForeignKey<Record, ?>> getReferences() {
        return (List)this.foreignKeysSupplier.get();
    }

    public Identity<Record, ?> getIdentity() {
        return (Identity)this.identitySupplier.get();
    }

    private class ForeignKeysSupplier
    implements Supplier<List<ForeignKey<Record, ?>>> {
        private final Function<FieldsPair, TableField<Record, ?>> FIELDS_PAIR_SOURCE = fieldsPair -> fieldsPair.source;
        private final Function<FieldsPair, TableField<Record, ?>> FIELDS_PAIR_TARGET = fieldsPair -> fieldsPair.target;

        private ForeignKeysSupplier() {
        }

        public List<ForeignKey<Record, ?>> get() {
            return Lists.newArrayList((Iterable)Collections2.transform(AbstractDataTable.this.foreignKeyFields.asMap().entrySet(), entry -> {
                TableField[] sourceFields = this.getTableFields((Map.Entry<Table<Record>, Collection<FieldsPair>>)entry, this.FIELDS_PAIR_SOURCE);
                TableField[] targetFields = this.getTableFields((Map.Entry<Table<Record>, Collection<FieldsPair>>)entry, this.FIELDS_PAIR_TARGET);
                AbstractDataTable targetTable = (AbstractDataTable)entry.getKey();
                UniqueKey<Record> targetKey = targetTable.new Keys().createKey(targetFields);
                return new Keys().createFK(targetKey, (Table<Record>)((Table)entry.getKey()), sourceFields);
            }));
        }

        private TableField[] getTableFields(Map.Entry<Table<Record>, Collection<FieldsPair>> entry, Function<FieldsPair, TableField<Record, ?>> extractor) {
            return (TableField[])Iterables.toArray((Iterable)Collections2.transform(entry.getValue(), extractor), TableField.class);
        }
    }

    private class PrimaryKeySupplier
    implements Supplier<UniqueKey<Record>> {
        private PrimaryKeySupplier() {
        }

        public UniqueKey<Record> get() {
            return new Keys().createPK();
        }
    }

    private class IdentitySupplier
    implements Supplier<Identity<Record, ?>> {
        private IdentitySupplier() {
        }

        public Identity<Record, ?> get() {
            return new Keys().createPKIdentity();
        }
    }

    private static class FieldsPair {
        final TableField<Record, ?> source;
        final TableField<Record, ?> target;

        FieldsPair(TableField<Record, ?> source, TableField<Record, ?> target) {
            this.source = source;
            this.target = target;
        }
    }

    private class Keys
    extends AbstractKeys {
        private Keys() {
        }

        UniqueKey<Record> createPK() {
            if (AbstractDataTable.this.primaryKeyFields.isEmpty()) {
                return null;
            }
            TableField[] pkFields = AbstractDataTable.this.primaryKeyFields.toArray(new TableField[AbstractDataTable.this.primaryKeyFields.size()]);
            return this.createKey(pkFields);
        }

        UniqueKey<Record> createKey(TableField<Record, ?>[] pkFields) {
            return Keys.createUniqueKey((Table)AbstractDataTable.this, pkFields);
        }

        ForeignKey<Record, ?> createFK(UniqueKey<Record> targetKey, Table<Record> table, TableField<Record, ?>[] fields) {
            return Keys.createForeignKey(targetKey, table, fields);
        }

        Identity<Record, ?> createPKIdentity() {
            return AbstractDataTable.this.identityField != null ? Keys.createIdentity((Table)AbstractDataTable.this, AbstractDataTable.this.identityField) : null;
        }
    }
}

