/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.jooq;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.jooq.BatchBindStep;
import org.jooq.Constraint;
import org.jooq.CreateTableColumnStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertValuesStepN;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.lambda.Seq;

public class DataTableUtils {
    public static <T extends Record> void createTable(DSLContext dslContext, Table<T> table) {
        dslContext.dropTableIfExists(table).execute();
        CreateTableColumnStep createTableAsStep = dslContext.createTable(table).columns(table.fields());
        UniqueKey primaryKey = table.getPrimaryKey();
        if (primaryKey != null) {
            createTableAsStep.constraints(new Constraint[]{DSL.constraint((String)"").primaryKey((Field[])primaryKey.getFieldsArray())}).execute();
        } else {
            createTableAsStep.execute();
        }
    }

    public static void populateTable(DSLContext dslContext, Table<Record> table, Object[][] data) {
        DataTableUtils.populate(dslContext, table, Lists.newArrayList((Object[])table.fields()), data);
    }

    public static void populateTableWithoutAutoIncFields(DSLContext dslContext, Table<Record> table, Object[][] data) {
        List fields = (List)Seq.of((Object[])table.fields()).filter(field -> !field.getDataType().identity()).collect(Collectors.toList());
        DataTableUtils.populate(dslContext, table, fields, data);
    }

    private static void populate(DSLContext dslContext, Table<Record> table, List<Field<?>> fields, Object[][] data) {
        InsertValuesStepN insert = dslContext.insertInto(table, fields).values(new Object[fields.size()]);
        BatchBindStep batch = dslContext.batch((Query)insert);
        for (Object[] values : data) {
            batch.bind(values);
        }
        batch.execute();
    }
}

