/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.jooq;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.kenshoo.jooq.TablePopulator;
import com.kenshoo.jooq.TempTable;
import com.kenshoo.jooq.TempTableResource;
import com.kenshoo.jooq.TransactionContextImpl;
import java.sql.SQLException;
import java.util.Objects;
import java.util.stream.Stream;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TransactionContext;
import org.jooq.TransactionProvider;
import org.jooq.impl.DSL;

class TempTableEngine {
    TempTableEngine() {
    }

    public static <T extends Table<Record>> TempTableResource<T> tempInMemoryTable(DSLContext dslContext, T table, TablePopulator tablePopulator) {
        return TempTableEngine.tempTable(dslContext, table, table.fields(), tablePopulator);
    }

    public static <T extends Table<Record>> TempTableResource<T> tempTable(DSLContext dslContext, T table, Field<?>[] fields, TablePopulator tablePopulator) {
        Preconditions.checkArgument((fields.length > 0 ? 1 : 0) != 0, (Object)"At least one field is required");
        return Stream.of(TempTable.Type.IN_MEMORY, TempTable.Type.REGULAR).map(type -> TempTableEngine.tempTable(dslContext, table, fields, tablePopulator, type)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new RuntimeException("Failed to create temp table"));
    }

    private static <T extends Table<Record>> TempTableResource<T> tempTable(DSLContext dslContext, final T table, Field<?>[] fields, TablePopulator tablePopulator, TempTable.Type tableType) {
        final TransactionProvider txProvider = dslContext.configuration().transactionProvider();
        Configuration newJooq = dslContext.configuration().derive();
        final TransactionContextImpl tx = new TransactionContextImpl(newJooq, dslContext);
        txProvider.begin((TransactionContext)tx);
        final TempTable<T> tempTable = new TempTable<T>(DSL.using((Configuration)newJooq), table, fields, tablePopulator, tableType);
        try {
            tempTable.create();
            return new TempTableResource<T>(){

                @Override
                public T getTable() {
                    return table;
                }

                @Override
                public void close() {
                    try {
                        tempTable.dropTable();
                    }
                    finally {
                        txProvider.commit(tx);
                    }
                }
            };
        }
        catch (Throwable e) {
            txProvider.rollback((TransactionContext)tx);
            if (tableType == TempTable.Type.IN_MEMORY && TempTableEngine.isFullTableError(e)) {
                return null;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static boolean isFullTableError(Throwable e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            return false;
        }
        if (!(cause instanceof SQLException)) {
            return false;
        }
        SQLException sqle = (SQLException)cause;
        return sqle.getErrorCode() == 1114 && "HY000".equals(sqle.getSQLState());
    }
}

