/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.kenshoo.jooq.DataTable;
import com.kenshoo.pl.entity.CommonTypesStringConverter;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityFieldDbAdapter;
import com.kenshoo.pl.entity.EntityFieldPrototype;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.IdField;
import com.kenshoo.pl.entity.PrototypedEntityField;
import com.kenshoo.pl.entity.ValueConverter;
import com.kenshoo.pl.entity.annotation.Id;
import com.kenshoo.pl.entity.annotation.IdGeneration;
import com.kenshoo.pl.entity.converters.EnumAsStringValueConverter;
import com.kenshoo.pl.entity.converters.IdentityValueConverter;
import com.kenshoo.pl.entity.equalityfunctions.EntityValueEqualityFunction;
import com.kenshoo.pl.entity.internal.EmptyVirtualEntityFieldDbAdapter;
import com.kenshoo.pl.entity.internal.EntityFieldImpl;
import com.kenshoo.pl.entity.internal.EntityTypeReflectionUtil;
import com.kenshoo.pl.entity.internal.PrototypedEntityFieldImpl;
import com.kenshoo.pl.entity.internal.SimpleEntityFieldDbAdapter;
import com.kenshoo.pl.entity.internal.VirtualEntityFieldDbAdapter;
import com.kenshoo.pl.entity.internal.VirtualEntityFieldDbAdapter2;
import com.kenshoo.pl.entity.internal.VirtualEntityFieldImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jooq.Record;
import org.jooq.TableField;

public abstract class AbstractEntityType<E extends EntityType<E>>
implements EntityType<E> {
    private final Supplier<Optional<IdField<E>>> idField = Suppliers.memoize(this::scanForIdField);
    private EntityField<E, Object> primaryIdentityField;
    private final String name;
    private Collection<EntityField<E, ?>> fields = new ArrayList();
    private Collection<PrototypedEntityField<E, ?>> prototypedFields = new ArrayList();
    private final Supplier<BiMap<String, EntityField<E, ?>>> fieldNameMappingSupplier = Suppliers.memoize(() -> EntityTypeReflectionUtil.getFieldToNameBiMap(this));

    protected AbstractEntityType(String name) {
        this.name = name;
    }

    protected <T> EntityField<E, T> field(TableField<Record, T> tableField) {
        return this.field(tableField, IdentityValueConverter.getInstance(tableField.getType()));
    }

    protected <T, DBT> EntityField<E, T> field(TableField<Record, DBT> tableField, ValueConverter<T, DBT> valueConverter) {
        return this.field(tableField, valueConverter, Objects::equals);
    }

    protected <T, DBT> EntityField<E, T> field(TableField<Record, DBT> tableField, ValueConverter<T, DBT> valueConverter, ValueConverter<T, String> stringValueConverter) {
        return this.field(tableField, valueConverter, stringValueConverter, Objects::equals);
    }

    protected <T> EntityField<E, T> field(TableField<Record, T> tableField, EntityValueEqualityFunction<T> valueEqualityFunction) {
        return this.field(tableField, IdentityValueConverter.getInstance(tableField.getType()), AbstractEntityType.createStringValueConverter(tableField.getType()), valueEqualityFunction);
    }

    protected <T, DBT> EntityField<E, T> field(TableField<Record, DBT> tableField, ValueConverter<T, DBT> valueConverter, EntityValueEqualityFunction<T> valueEqualityFunction) {
        return this.field(tableField, valueConverter, AbstractEntityType.createStringValueConverter(valueConverter.getValueClass()), valueEqualityFunction);
    }

    protected <T, DBT> EntityField<E, T> field(TableField<Record, DBT> tableField, ValueConverter<T, DBT> valueConverter, ValueConverter<T, String> stringValueConverter, EntityValueEqualityFunction<T> valueEqualityFunction) {
        return this.addField(new EntityFieldImpl(this, new SimpleEntityFieldDbAdapter<T, DBT>(tableField, valueConverter), stringValueConverter, valueEqualityFunction));
    }

    protected <T> EntityField<E, T> field(EntityFieldDbAdapter<T> dbAdapter, ValueConverter<T, String> stringValueConverter) {
        return this.addField(new EntityFieldImpl(this, dbAdapter, stringValueConverter, Objects::equals));
    }

    protected <T, T1> EntityField<E, T> virtualField(EntityField<E, T1> field1, Function<T1, T> translator, ValueConverter<T, String> stringValueConverter, EntityValueEqualityFunction<T> valueEqualityFunction) {
        return this.virtualField(new VirtualEntityFieldDbAdapter<T, T1>(field1.getDbAdapter(), translator), stringValueConverter, valueEqualityFunction);
    }

    protected <T> EntityField<E, T> virtualField(DataTable table, ValueConverter<T, String> stringValueConverter, EntityValueEqualityFunction<T> valueEqualityFunction) {
        return this.virtualField(new EmptyVirtualEntityFieldDbAdapter(table), stringValueConverter, valueEqualityFunction);
    }

    protected <T, T1, T2> EntityField<E, T> virtualField(EntityField<E, T1> field1, EntityField<E, T2> field2, BiFunction<T1, T2, T> combiner, ValueConverter<T, String> stringValueConverter, EntityValueEqualityFunction<T> valueEqualityFunction) {
        return this.virtualField(new VirtualEntityFieldDbAdapter2<T, T1, T2>(field1.getDbAdapter(), field2.getDbAdapter(), combiner), stringValueConverter, valueEqualityFunction);
    }

    private <T> EntityField<E, T> virtualField(EntityFieldDbAdapter<T> entityFieldDbAdapter, ValueConverter<T, String> stringValueConverter, EntityValueEqualityFunction<T> valueEqualityFunction) {
        return this.addField(new VirtualEntityFieldImpl(this, entityFieldDbAdapter, stringValueConverter, valueEqualityFunction));
    }

    private static <T> ValueConverter<T, String> createStringValueConverter(Class<T> valueClass) {
        if (Enum.class.isAssignableFrom(valueClass)) {
            return EnumAsStringValueConverter.create(valueClass);
        }
        if (!CommonTypesStringConverter.isSupported(valueClass)) {
            throw new IllegalArgumentException("Class " + valueClass + " is not supported out of the box, please specify a converter to/from String");
        }
        return new CommonTypesStringConverter<T>(valueClass);
    }

    protected <T> PrototypedEntityField<E, T> prototypedField(EntityFieldPrototype<T> entityFieldPrototype, TableField<Record, T> tableField) {
        return this.prototypedField(entityFieldPrototype, tableField, IdentityValueConverter.getInstance(tableField.getType()));
    }

    protected <T> PrototypedEntityField<E, T> prototypedField(EntityFieldPrototype<T> entityFieldPrototype, TableField<Record, T> tableField, EntityValueEqualityFunction<T> valueEqualityFunction) {
        return this.prototypedField(entityFieldPrototype, tableField, IdentityValueConverter.getInstance(tableField.getType()), valueEqualityFunction);
    }

    protected <T, DBT> PrototypedEntityField<E, T> prototypedField(EntityFieldPrototype<T> entityFieldPrototype, TableField<Record, DBT> tableField, ValueConverter<T, DBT> valueConverter) {
        return this.prototypedField(entityFieldPrototype, tableField, valueConverter, Objects::equals);
    }

    protected <T, DBT> PrototypedEntityField<E, T> prototypedField(EntityFieldPrototype<T> entityFieldPrototype, TableField<Record, DBT> tableField, ValueConverter<T, DBT> valueConverter, EntityValueEqualityFunction<T> valueEqualityFunction) {
        PrototypedEntityFieldImpl field = new PrototypedEntityFieldImpl(this, entityFieldPrototype, new SimpleEntityFieldDbAdapter<T, DBT>(tableField, valueConverter), AbstractEntityType.createStringValueConverter(valueConverter.getValueClass()), valueEqualityFunction);
        this.prototypedFields.add(field);
        return this.addField(field);
    }

    private <T, F extends EntityField<E, T>> F addField(F field) {
        this.fields.add(field);
        if (this.primaryIdentityField == null && this.isPrimaryIdentityField(field)) {
            this.primaryIdentityField = field;
        }
        return field;
    }

    private boolean isPrimaryIdentityField(EntityField<E, ?> field) {
        EntityFieldDbAdapter<?> dbAdapter = field.getDbAdapter();
        return dbAdapter.getTable() == this.getPrimaryTable() && dbAdapter.isIdentityField();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private Optional<IdField<E>> scanForIdField() {
        Optional<IdField<E>> idField = this.getFields().map(field -> Optional.ofNullable(EntityTypeReflectionUtil.getFieldAnnotation(this, field, Id.class)).map(a -> new IdField(field, a.value()))).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (idField.isPresent() && !Number.class.isAssignableFrom(idField.get().getField().getValueClass())) {
            throw new RuntimeException("Field marked with " + Id.class.getName() + " should be either Integer or Long , field " + this.toFieldName(idField.get().getField()) + " is of type " + idField.get().getField().getStringValueConverter().getValueClass().getName());
        }
        return idField;
    }

    @Override
    public Optional<EntityField<E, ? extends Number>> getIdField() {
        return ((Optional)this.idField.get()).map(IdField::getField);
    }

    @Override
    public Optional<EntityField<E, Object>> getPrimaryIdentityField() {
        return Optional.ofNullable(this.primaryIdentityField);
    }

    @Override
    public Optional<IdGeneration> getIdGeneration() {
        return ((Optional)this.idField.get()).map(IdField::getIdGeneration);
    }

    @Override
    public Stream<EntityField<E, ?>> getFields() {
        return this.fields.stream();
    }

    @Override
    public Stream<PrototypedEntityField<E, ?>> getPrototypedFields() {
        return this.prototypedFields.stream();
    }

    @Override
    public EntityField<E, ?> getFieldByName(String name) {
        BiMap fieldToNameBiMap = (BiMap)this.fieldNameMappingSupplier.get();
        if (fieldToNameBiMap.containsKey((Object)name)) {
            return (EntityField)fieldToNameBiMap.get((Object)name);
        }
        throw new IllegalArgumentException("Requested EntityField does not exist: '" + name + "'.");
    }

    @Override
    public String toFieldName(EntityField<E, ?> field) {
        BiMap fieldToNameBiMap = (BiMap)this.fieldNameMappingSupplier.get();
        return (String)fieldToNameBiMap.inverse().get(field);
    }
}

