/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.google.common.collect.ImmutableMap;
import com.kenshoo.pl.entity.ValueConverter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;

public class CommonTypesStringConverter<T>
implements ValueConverter<T, String> {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final Map<Class<?>, Function<?, String>> TO_STRING_FUNCTION_BY_CLASS = ImmutableMap.builder().put(Timestamp.class, o -> Long.toString(((Timestamp)o).getTime())).put(Instant.class, i -> Long.toString(((Instant)i).toEpochMilli())).put(LocalDate.class, DATE_FORMATTER::format).build();
    private static final Map<Class<?>, Function<String, ?>> FROM_STRING_FUNCTION_BY_CLASS = ImmutableMap.builder().put(String.class, Function.identity()).put(Integer.class, Integer::parseInt).put(Long.class, Long::parseLong).put(Double.class, Double::parseDouble).put(Float.class, Float::parseFloat).put(Boolean.class, s -> BooleanUtils.toBoolean((String)s, (String)Boolean.TRUE.toString(), (String)Boolean.FALSE.toString())).put(BigDecimal.class, BigDecimal::new).put(Timestamp.class, s -> new Timestamp(Long.parseLong(s))).put(Instant.class, s -> Instant.ofEpochMilli(Long.parseLong(s))).put(LocalDate.class, s -> DATE_FORMATTER.parse((CharSequence)s, LocalDate::from)).build();
    private Class<T> valueClass;

    public CommonTypesStringConverter(Class<T> valueClass) {
        if (!CommonTypesStringConverter.isSupported(valueClass)) {
            throw new IllegalArgumentException("CommonTypesStringConverter does't support class '" + valueClass.getSimpleName() + "', please implement a dedicated converter.");
        }
        this.valueClass = valueClass;
    }

    public static <T> boolean isSupported(Class<T> valueClass) {
        return FROM_STRING_FUNCTION_BY_CLASS.containsKey(valueClass);
    }

    @Override
    public String convertTo(T value) {
        return TO_STRING_FUNCTION_BY_CLASS.getOrDefault(this.valueClass, Objects::toString).apply(value);
    }

    @Override
    public T convertFrom(String value) {
        return (T)FROM_STRING_FUNCTION_BY_CLASS.get(this.valueClass).apply(value);
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }
}

