/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.google.common.annotations.VisibleForTesting;
import com.kenshoo.pl.entity.ChangeEntityCommand;
import com.kenshoo.pl.entity.ChangeFlowConfig;
import com.kenshoo.pl.entity.DeleteEntityCommand;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FullIdentifier;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.IdentifierType;
import com.kenshoo.pl.entity.PLContext;
import com.kenshoo.pl.entity.UniqueKeyValue;
import com.kenshoo.pl.entity.internal.ChildrenIdFetcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public class DeletionCommandPopulator {
    private final ChildrenIdFetcher childrenIdFetcher;

    public DeletionCommandPopulator(PLContext plContext) {
        this.childrenIdFetcher = new ChildrenIdFetcher(plContext);
    }

    @VisibleForTesting
    public DeletionCommandPopulator(ChildrenIdFetcher childrenIdFetcher) {
        this.childrenIdFetcher = childrenIdFetcher;
    }

    public <PARENT extends EntityType<PARENT>> void handleRecursive(Iterable<? extends ChangeEntityCommand<PARENT>> parents, ChangeFlowConfig<PARENT> config) {
        List parentsWithChildSupplier = Seq.seq(parents).filter(this::recursivelyCheckIfAnyShouldCascade).toList();
        if (parentsWithChildSupplier.isEmpty()) {
            return;
        }
        Seq.seq(config.childFlows()).forEach(childflow -> this.handleChildFlow(parentsWithChildSupplier, (ChangeFlowConfig)childflow));
    }

    private <PARENT extends EntityType<PARENT>, CHILD extends EntityType<CHILD>> void handleChildFlow(Collection<? extends ChangeEntityCommand<PARENT>> parents, ChangeFlowConfig<CHILD> childFlow) {
        Object childType = childFlow.getEntityType();
        ChildrenFromDB<PARENT, CHILD> childrenFromDB = this.getExistingChildrenFromDB(parents, childType);
        this.addDeletionChildCommands((Stream<? extends ChangeEntityCommand<PARENT>>)Seq.seq(parents).filter(this::isCascadeDeletion), childType, childrenFromDB);
        this.supplyChildCommands((Stream<? extends ChangeEntityCommand<PARENT>>)Seq.seq(parents).filter(this::withMissingChildSupplier), childType, childrenFromDB);
        this.populateKeyToParent(parents, childType, childrenFromDB);
        this.handleRecursive((Iterable<? extends ChangeEntityCommand<PARENT>>)Seq.seq(parents).flatMap(p -> p.getChildren(childType)).filter(child -> child.getKeysToParent() != null), (ChangeFlowConfig<PARENT>)childFlow);
    }

    private <PARENT extends EntityType<PARENT>, CHILD extends EntityType<CHILD>> ChildrenFromDB<PARENT, CHILD> getExistingChildrenFromDB(Collection<? extends ChangeEntityCommand<PARENT>> parents, CHILD childType) {
        List parentIds = Seq.seq(parents).map(p -> DeletionCommandPopulator.concatenatedId(p)).toList();
        IdentifierType childKey = this.identifierOfFirstChildCmd(parents, childType).orElseGet(childType::getPrimaryKey);
        return new ChildrenFromDB(this.childrenIdFetcher.fetch(parentIds, childKey));
    }

    private <PARENT extends EntityType<PARENT>, CHILD extends EntityType<CHILD>> void supplyChildCommands(Stream<? extends ChangeEntityCommand<PARENT>> parents, CHILD childType, ChildrenFromDB<PARENT, CHILD> childrenFromDB) {
        parents.forEach(parent -> {
            Set<Identifier<EntityType>> childrenFromCommand = this.childrenIdsOf(childType, (ChangeEntityCommand)parent);
            Seq.seq(childrenFromDB.getChildIds((ChangeEntityCommand)parent)).filter(childIds -> !childrenFromCommand.contains(childIds)).forEach(missingChildIds -> parent.getMissingChildrenSupplier(childType).flatMap(s -> s.supplyNewCommand(missingChildIds)).ifPresent(newCmd -> parent.addChild(newCmd)));
        });
    }

    private <PARENT extends EntityType<PARENT>, CHILD extends EntityType<CHILD>> void addDeletionChildCommands(Stream<? extends ChangeEntityCommand<PARENT>> parents, CHILD childType, ChildrenFromDB<PARENT, CHILD> childrenFromDB) {
        parents.forEach(parent -> childrenFromDB.getChildIds((ChangeEntityCommand)parent).forEach(childId -> {
            DeleteEntityCommand<EntityType, Identifier> newCmd = new DeleteEntityCommand<EntityType, Identifier>(childType, (Identifier)childId).setCascade();
            parent.addChild(newCmd);
        }));
    }

    private <PARENT extends EntityType<PARENT>, CHILD extends EntityType<CHILD>> void populateKeyToParent(Collection<? extends ChangeEntityCommand<PARENT>> parents, CHILD childType, ChildrenFromDB<PARENT, CHILD> childrenFromDB) {
        Seq.seq(parents).forEach(parent -> {
            ChildrenWithKeyToParent childrenOfParent = childrenFromDB.of((ChangeEntityCommand)parent);
            parent.getChildren(childType).forEach(child -> child.setKeysToParent(childrenOfParent.keyToParentOf(child.getIdentifier())));
        });
    }

    private static <E extends EntityType<E>> Identifier<E> concatenatedId(ChangeEntityCommand<E> currentState) {
        return UniqueKeyValue.concat(currentState.getIdentifier(), currentState.getKeysToParent());
    }

    private <PARENT extends EntityType<PARENT>, CHILD extends EntityType<CHILD>> Set<Identifier<CHILD>> childrenIdsOf(CHILD childType, ChangeEntityCommand<PARENT> parent) {
        return parent.getChildren(childType).map(EntityChange::getIdentifier).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private <E extends EntityType<E>> boolean recursivelyCheckIfAnyShouldCascade(ChangeEntityCommand<E> parent) {
        return this.withMissingChildSupplier(parent) || this.isCascadeDeletion(parent) || parent.getChildren().anyMatch(child -> this.recursivelyCheckIfAnyShouldCascade((ChangeEntityCommand)child));
    }

    private <E extends EntityType<E>> boolean isCascadeDeletion(ChangeEntityCommand<E> cmd) {
        return cmd instanceof DeleteEntityCommand && ((DeleteEntityCommand)cmd).isCascade();
    }

    private <PARENT extends EntityType<PARENT>> boolean withMissingChildSupplier(ChangeEntityCommand<PARENT> cmd) {
        return !cmd.getMissingChildrenSuppliers().isEmpty();
    }

    private <PARENT extends EntityType<PARENT>, CHILD extends EntityType<CHILD>> Optional<IdentifierType<CHILD>> identifierOfFirstChildCmd(Collection<? extends ChangeEntityCommand<PARENT>> parents, CHILD childType) {
        return parents.stream().flatMap(p -> p.getChildren(childType)).map(EntityChange::getIdentifier).filter(Objects::nonNull).map(Identifier::getUniqueKey).findFirst();
    }

    private static class ChildrenWithKeyToParent<CHILD extends EntityType<CHILD>> {
        final Map<Identifier<CHILD>, Identifier<CHILD>> map;

        private ChildrenWithKeyToParent(Map<Identifier<CHILD>, Identifier<CHILD>> childrenWithKeyToParent) {
            this.map = childrenWithKeyToParent;
        }

        public Identifier<CHILD> keyToParentOf(Identifier<CHILD> childId) {
            return this.map.get(childId);
        }
    }

    private static class ChildrenFromDB<PARENT extends EntityType<PARENT>, CHILD extends EntityType<CHILD>> {
        final Map<Identifier<PARENT>, ChildrenWithKeyToParent<CHILD>> map;
        final ChildrenWithKeyToParent<CHILD> EMPTY = new ChildrenWithKeyToParent(Collections.emptyMap());

        public ChildrenFromDB(Stream<FullIdentifier<PARENT, CHILD>> stream) {
            this.map = stream.collect(Collectors.groupingBy(FullIdentifier::getParentId, Collectors.collectingAndThen(Collectors.toMap(FullIdentifier::getChildId, FullIdentifier::getKetToParent), x$0 -> new ChildrenWithKeyToParent(x$0))));
        }

        ChildrenWithKeyToParent<CHILD> of(ChangeEntityCommand<PARENT> parent) {
            return this.map.getOrDefault(DeletionCommandPopulator.concatenatedId(parent), this.EMPTY);
        }

        Set<Identifier<CHILD>> getChildIds(ChangeEntityCommand<PARENT> parent) {
            return this.of(parent).map.keySet();
        }
    }
}

