/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.google.common.collect.ImmutableList;
import com.kenshoo.pl.entity.ChangeEntityCommand;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.ValidationError;
import java.util.Collection;
import java.util.Collections;

public abstract class EntityChangeResult<E extends EntityType<E>, ID extends Identifier<E>, C extends ChangeEntityCommand<E>> {
    private final C command;
    private final Collection<ValidationError> errors;

    public EntityChangeResult(C command) {
        this(command, Collections.emptyList());
    }

    public EntityChangeResult(C command, Iterable<ValidationError> errors) {
        this.command = command;
        this.errors = ImmutableList.copyOf(errors);
    }

    public C getCommand() {
        return this.command;
    }

    public boolean isSuccess() {
        return this.errors.isEmpty();
    }

    public Collection<ValidationError> getErrors() {
        return this.errors;
    }

    public abstract ID getIdentifier();
}

