/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.kenshoo.pl.entity.EntityFieldDbAdapter;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.PLCondition;
import com.kenshoo.pl.entity.ValueConverter;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Record;
import org.jooq.TableField;
import org.jooq.lambda.Seq;

public interface EntityField<E extends EntityType<E>, T> {
    public EntityFieldDbAdapter<T> getDbAdapter();

    public ValueConverter<T, String> getStringValueConverter();

    public boolean valuesEqual(T var1, T var2);

    default public Class<T> getValueClass() {
        return this.getStringValueConverter().getValueClass();
    }

    default public boolean isVirtual() {
        return false;
    }

    public EntityType<E> getEntityType();

    default public PLCondition eq(T value) {
        if (this.isVirtual()) {
            throw new UnsupportedOperationException("The equals operation is unsupported for virtual fields");
        }
        Object tableValue = this.getDbAdapter().getFirstDbValue(value);
        TableField<Record, ?> tableField = this.getDbAdapter().getFirstTableField();
        return new PLCondition(tableField.eq(tableValue), entity -> entity.safeGet(this).equalsValue(value), this);
    }

    default public PLCondition in(T ... values) {
        if (this.isVirtual()) {
            throw new UnsupportedOperationException("The in operation is unsupported for virtual fields");
        }
        Object[] tableValues = Arrays.stream(values).map(value -> this.getDbAdapter().getFirstDbValue(value)).toArray(Object[]::new);
        TableField<Record, ?> tableField = this.getDbAdapter().getFirstTableField();
        Set setOfValues = (Set)Seq.of((Object[])values).collect(Collectors.toUnmodifiableSet());
        return new PLCondition(tableField.in(tableValues), entity -> entity.safeGet(this).filter(Objects::nonNull).matches(setOfValues::contains), this);
    }

    default public PLCondition isNull() {
        if (this.isVirtual()) {
            throw new UnsupportedOperationException("The equals operation is unsupported for virtual fields");
        }
        TableField<Record, ?> tableField = this.getDbAdapter().getFirstTableField();
        return new PLCondition(tableField.isNull(), entity -> entity.safeGet(this).isNull(), this);
    }
}

