/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.kenshoo.jooq.DataTable;
import com.kenshoo.pl.data.CreateRecordCommand;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.PrototypedEntityField;
import com.kenshoo.pl.entity.SupportedChangeOperation;
import com.kenshoo.pl.entity.UniqueKey;
import com.kenshoo.pl.entity.annotation.IdGeneration;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Key;
import org.jooq.Record;
import org.jooq.TableField;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;

public interface EntityType<E extends EntityType<E>> {
    public String getName();

    public DataTable getPrimaryTable();

    default public Optional<EntityField<E, Object>> getPrimaryIdentityField() {
        return Optional.empty();
    }

    default public Optional<EntityField<E, ? extends Number>> getIdField() {
        return Optional.empty();
    }

    default public Optional<IdGeneration> getIdGeneration() {
        return Optional.empty();
    }

    public Stream<EntityField<E, ?>> getFields();

    public Stream<PrototypedEntityField<E, ?>> getPrototypedFields();

    public EntityField<E, ?> getFieldByName(String var1);

    public String toFieldName(EntityField<E, ?> var1);

    default public SupportedChangeOperation getSupportedOperation() {
        return SupportedChangeOperation.CREATE_AND_UPDATE;
    }

    default public CreateRecordCommand.OnDuplicateKey onDuplicateKey() {
        return CreateRecordCommand.OnDuplicateKey.FAIL;
    }

    default public Collection<EntityField<E, ?>> findFields(Iterable<TableField<Record, ?>> tableFields) {
        return (Collection)Seq.seq(tableFields).map(tableField -> this.findField((TableField)tableField)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    default public Optional<EntityField<E, ?>> findField(TableField tableField) {
        return this.getFields().filter(entityField -> entityField.getDbAdapter().getTableFields().anyMatch(Predicate.isEqual(tableField))).findFirst();
    }

    default public Stream<EntityField<E, ?>> determineForeignKeys(Set<EntityField<E, ?>> requiredFields) {
        Set foreignKeyFields = this.getPrimaryTable().getReferences().stream().map(Key::getFields).flatMap(Collection::stream).collect(Collectors.toSet());
        return requiredFields.stream().filter(entityField -> entityField.getDbAdapter().getTableFields().anyMatch(foreignKeyFields::contains));
    }

    default public <TO extends EntityType<TO>> ForeignKey<E, TO> getKeyTo(EntityType<TO> other) {
        org.jooq.ForeignKey<Record, Record> foreignKey = this.getPrimaryTable().getForeignKey(other.getPrimaryTable());
        return new ForeignKey(this.findFields(foreignKey.getFields()), other.findFields(foreignKey.getKey().getFields()));
    }

    default public UniqueKey<E> getPrimaryKey() {
        org.jooq.UniqueKey dbKey = this.getPrimaryTable().getPrimaryKey();
        Collection<EntityField<E, ?>> fields = this.findFields(dbKey.getFields());
        return new UniqueKey<E>(fields);
    }

    public static class ForeignKey<FROM extends EntityType<FROM>, TO extends EntityType<TO>> {
        public final Collection<Tuple2<EntityField<FROM, ?>, EntityField<TO, ?>>> references;

        public ForeignKey(Collection<EntityField<FROM, ?>> from, Collection<EntityField<TO, ?>> to) {
            this.references = Seq.seq(from).zip(to).toList();
        }

        public ForeignKey(Iterable<Tuple2<EntityField<FROM, ?>, EntityField<TO, ?>>> references) {
            this.references = Seq.seq(references).toList();
        }

        public boolean notEmpty() {
            return this.size() > 0;
        }

        public int size() {
            return this.references.size();
        }

        public Collection<? extends EntityField<FROM, ?>> from() {
            return Seq.seq(this.references).map(pair -> (EntityField)pair.v1).toList();
        }

        public Collection<? extends EntityField<TO, ?>> to() {
            return Seq.seq(this.references).map(pair -> (EntityField)pair.v2).toList();
        }

        public ForeignKey<FROM, TO> filterByTo(Predicate<EntityField<TO, ?>> predicate) {
            return new ForeignKey<FROM, TO>(Seq.seq(this.references).filter(pair -> predicate.test((EntityField)pair.v2)));
        }

        public String toString() {
            return Seq.seq(this.references).map(pair -> "[" + this.fieldName((EntityField)pair.v1) + "-->" + this.fieldName((EntityField)pair.v2) + "]").toString((CharSequence)", ");
        }

        private String fieldName(EntityField field) {
            return field.getDbAdapter().getTable().getName() + "." + field;
        }
    }
}

