/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import java.util.Objects;

public class FieldFetchRequest {
    private final EntityType whereToQuery;
    private final EntityType whoAskedForThis;
    private final EntityField<?, ?> entityField;

    FieldFetchRequest(EntityType whereToQuery, EntityType whoAskedForThis, EntityField<?, ?> entityField) {
        this.whereToQuery = whereToQuery;
        this.whoAskedForThis = whoAskedForThis;
        this.entityField = entityField;
    }

    public EntityType getWhereToQuery() {
        return this.whereToQuery;
    }

    public EntityType getWhoAskedForThis() {
        return this.whoAskedForThis;
    }

    public EntityField<?, ?> getEntityField() {
        return this.entityField;
    }

    public boolean supports(ChangeOperation changeOperation) {
        return this.getEntityField().getEntityType() != this.whereToQuery || changeOperation != ChangeOperation.CREATE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldFetchRequest that = (FieldFetchRequest)o;
        return Objects.equals(this.whereToQuery, that.whereToQuery) && Objects.equals(this.whoAskedForThis, that.whoAskedForThis) && Objects.equals(this.entityField, that.entityField);
    }

    public int hashCode() {
        return Objects.hash(this.whereToQuery, this.whoAskedForThis, this.entityField);
    }

    public static Builder newRequest() {
        return new Builder();
    }

    public static class Builder {
        private EntityType whereToQuery;
        private EntityType whoAskedForThis;
        private EntityField<?, ?> entityField;

        public FieldFetchRequest build() {
            return new FieldFetchRequest(this.whereToQuery, this.whoAskedForThis, this.entityField);
        }

        public Builder queryOn(EntityType v) {
            this.whereToQuery = v;
            return this;
        }

        public Builder askedBy(EntityType v) {
            this.whoAskedForThis = v;
            return this;
        }

        public Builder field(EntityField v) {
            this.entityField = v;
            return this;
        }
    }
}

