/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.kenshoo.pl.entity.ChangeEntityCommand;
import com.kenshoo.pl.entity.ChangeFlowConfig;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FieldFetchRequest;
import com.kenshoo.pl.entity.Hierarchy;
import com.kenshoo.pl.entity.SupportedChangeOperation;
import com.kenshoo.pl.entity.spi.CurrentStateConsumer;
import com.kenshoo.pl.entity.spi.PostFetchCommandEnricher;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.function.Functions;

public class FieldsToFetchBuilder<ROOT extends EntityType<ROOT>> {
    public Collection<FieldFetchRequest> build(Collection<? extends ChangeEntityCommand<ROOT>> commands, ChangeFlowConfig<ROOT> flowConfig) {
        return this.prepareFieldsToFetchRecursive(Hierarchy.build(flowConfig), commands, flowConfig).toList();
    }

    private <E extends EntityType<E>> Seq<FieldFetchRequest> prepareFieldsToFetchRecursive(Hierarchy hierarchy, Collection<? extends ChangeEntityCommand<E>> commands, ChangeFlowConfig<E> flow) {
        return Seq.concat((Seq[])new Seq[]{this.getForOneLevel(hierarchy, this.only(commands, this.withOperator(ChangeOperation.UPDATE)), ChangeOperation.UPDATE, flow), this.getForOneLevel(hierarchy, this.only(commands, this.withOperator(ChangeOperation.CREATE).or(this.withAllowMissingEntity())), ChangeOperation.CREATE, flow), this.getForOneLevel(hierarchy, this.only(commands, this.withOperator(ChangeOperation.DELETE)), ChangeOperation.DELETE, flow), Seq.seq(flow.childFlows()).flatMap(childFlow -> this.prepareChildFieldsToFetchRecursive(hierarchy, commands, (ChangeFlowConfig)childFlow))});
    }

    private <PARENT extends EntityType<PARENT>, CHILD extends EntityType<CHILD>> Seq<FieldFetchRequest> prepareChildFieldsToFetchRecursive(Hierarchy hierarchy, Collection<? extends ChangeEntityCommand<PARENT>> commands, ChangeFlowConfig<CHILD> childFlow) {
        return this.prepareFieldsToFetchRecursive(hierarchy, commands.stream().flatMap(parent -> parent.getChildren(childFlow.getEntityType())).collect(Collectors.toList()), childFlow);
    }

    private <E extends EntityType<E>> Seq<FieldFetchRequest> getForOneLevel(Hierarchy hierarchy, Collection<? extends ChangeEntityCommand<E>> commands, ChangeOperation operation, ChangeFlowConfig<E> flow) {
        if (commands.isEmpty()) {
            return Seq.empty();
        }
        Object currentLevel = flow.getEntityType();
        Stream currentStateConsumers = Stream.concat(flow.currentStateConsumers(), this.consumerOf(commands)).filter(CurrentStateConsumer.supporting(operation));
        Seq fields = Seq.concat((Stream[])new Stream[]{this.fieldsConsumedBy(commands, operation, flow, currentStateConsumers), this.foreignKeyFieldsRelatedByChildrenOf(commands, flow, hierarchy, operation), this.fieldsOfIdentifiersOf(commands, operation)});
        return fields.flatMap(field -> {
            if (this.isSameLevel(flow, (EntityField<?, ?>)field)) {
                return Seq.of((Object)FieldFetchRequest.newRequest().field((EntityField)field).queryOn((EntityType)currentLevel).askedBy((EntityType)currentLevel).build());
            }
            if (hierarchy.contains((EntityField<?, ?>)field)) {
                return Seq.of((Object)FieldFetchRequest.newRequest().field((EntityField)field).queryOn(field.getEntityType()).askedBy((EntityType)currentLevel).build());
            }
            return Seq.of((Object)FieldFetchRequest.newRequest().field((EntityField)field).queryOn(hierarchy.root()).askedBy((EntityType)currentLevel).build());
        });
    }

    private <E extends EntityType<E>> Stream<? extends EntityField<?, ?>> fieldsConsumedBy(Collection<? extends ChangeEntityCommand<E>> commands, ChangeOperation operation, ChangeFlowConfig<E> flow, Stream<CurrentStateConsumer<E>> currentStateConsumers) {
        Stream fieldsByCommands = commands.stream().flatMap(ChangeEntityCommand::getChangedFields);
        Stream fieldsToEnrich = flow.getPostFetchCommandEnrichers().stream().filter(enricher -> enricher.shouldRun(commands)).flatMap(PostFetchCommandEnricher::fieldsToEnrich);
        Set fieldsToUpdate = Stream.concat(fieldsByCommands, fieldsToEnrich).collect(Collectors.toSet());
        return currentStateConsumers.flatMap(consumer -> this.filterFieldsByOperator(flow, operation, (Stream)consumer.requiredFields(fieldsToUpdate, operation), (CurrentStateConsumer)consumer));
    }

    private <E extends EntityType<E>> Stream<EntityField<E, ?>> fieldsOfIdentifiersOf(Collection<? extends ChangeEntityCommand<E>> commands, ChangeOperation operation) {
        if (!commands.isEmpty() && SupportedChangeOperation.UPDATE_AND_DELETE.supports(operation)) {
            ChangeEntityCommand<E> cmd = commands.stream().findFirst().get();
            return this.uniqueFields(cmd);
        }
        return Stream.empty();
    }

    private <E extends EntityType<E>> Stream<? extends EntityField<?, ?>> foreignKeyFieldsRelatedByChildrenOf(Collection<? extends ChangeEntityCommand<E>> commands, ChangeFlowConfig<E> flow, Hierarchy hierarchy, ChangeOperation operation) {
        if (SupportedChangeOperation.UPDATE_AND_DELETE.supports(operation) && this.hasAnyChildCommand(commands)) {
            Object entityType = flow.getEntityType();
            Collection<EntityType<?>> children = hierarchy.childrenTypes((EntityType<?>)entityType);
            return children.stream().map(child -> child.getKeyTo(entityType).to()).flatMap(Collection::stream);
        }
        return Stream.empty();
    }

    private <E extends EntityType<E>> Stream<EntityField<E, ?>> uniqueFields(ChangeEntityCommand<E> cmd) {
        return Arrays.stream(cmd.getIdentifier().getUniqueKey().getFields());
    }

    private <E extends EntityType<E>> boolean hasAnyChildCommand(Collection<? extends ChangeEntityCommand<E>> commands) {
        return commands.stream().flatMap(ChangeEntityCommand::getChildren).findAny().isPresent();
    }

    private <E extends EntityType<E>> boolean isSameLevel(ChangeFlowConfig<E> flow, EntityField<?, ?> field) {
        return flow.getEntityType().equals(field.getEntityType());
    }

    private <T> List<? extends T> only(Iterable<? extends T> items, Predicate<? super T> predicate) {
        return Seq.seq(items).filter(predicate).toList();
    }

    private Predicate<EntityChange<?>> withOperator(ChangeOperation op) {
        return cmd -> op == cmd.getChangeOperation();
    }

    private Predicate<? super EntityChange<?>> withAllowMissingEntity() {
        return EntityChange::allowMissingEntity;
    }

    private <E extends EntityType<E>> Stream<CurrentStateConsumer<E>> consumerOf(Collection<? extends ChangeEntityCommand<E>> commands) {
        return commands.stream().flatMap(ChangeEntityCommand::getCurrentStateConsumers);
    }

    private <E extends EntityType<E>, EF extends EntityField<?, ?>> Stream<EF> filterFieldsByOperator(ChangeFlowConfig<E> flowConfig, ChangeOperation changeOperation, Stream<EF> fieldsToFetch, CurrentStateConsumer<E> consumer) {
        if (changeOperation == ChangeOperation.CREATE) {
            return fieldsToFetch.filter(Functions.not(this.ofEntity((EntityType<E>)flowConfig.getEntityType())));
        }
        return fieldsToFetch;
    }

    private <E extends EntityType<E>, EF extends EntityField<?, ?>> Predicate<EF> ofEntity(EntityType<E> entityType) {
        return entityField -> entityField.getEntityType().equals(entityType);
    }
}

