/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.kenshoo.pl.entity.ChangeFlowConfig;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.lambda.Seq;

public class Hierarchy {
    private final EntityType<?> root;
    private final Set<Pair<EntityType<?>, EntityType<?>>> parentChildRelations;

    Hierarchy(EntityType<?> root, Set<Pair<EntityType<?>, EntityType<?>>> parentChildRelations) {
        this.root = root;
        this.parentChildRelations = parentChildRelations;
    }

    static Hierarchy build(ChangeFlowConfig rootFlow) {
        Set<Pair<EntityType<?>, EntityType<?>>> relations = Hierarchy.getRelationsRecursively(rootFlow).collect(Collectors.toSet());
        return new Hierarchy((EntityType<?>)rootFlow.getEntityType(), relations);
    }

    public Collection<? extends EntityType<?>> childrenTypes(EntityType<?> parent) {
        return Seq.seq(this.parentChildRelations).filter(pair -> ((EntityType)pair.getLeft()).equals(parent)).map(Pair::getRight).toList();
    }

    public Optional<? extends EntityType<?>> getParent(EntityType<?> child) {
        return this.parentChildRelations.stream().filter(i -> i.getRight() == child).map(Pair::getLeft).findFirst();
    }

    EntityType<?> root() {
        return this.root;
    }

    boolean contains(EntityField<?, ?> field) {
        return Seq.seq(this.parentChildRelations).anyMatch(pair -> field.getEntityType().equals(pair.getLeft()) || field.getEntityType().equals(pair.getRight()));
    }

    private static Stream<Pair<EntityType<?>, EntityType<?>>> getRelationsRecursively(ChangeFlowConfig<?> flow) {
        Stream<Pair> myRelations = flow.childFlows().stream().map(childFlow -> Pair.of(flow.getEntityType(), childFlow.getEntityType()));
        return Stream.concat(myRelations, flow.childFlows().stream().flatMap(f -> Hierarchy.getRelationsRecursively(f)));
    }
}

