/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.Feature;
import com.kenshoo.pl.entity.FeatureSet;
import com.kenshoo.pl.entity.FetchFromStep;
import com.kenshoo.pl.entity.FluentEntitiesFetcher;
import com.kenshoo.pl.entity.internal.EntitiesFetcher;
import com.kenshoo.pl.entity.spi.PersistenceLayerRetryer;
import com.kenshoo.pl.entity.spi.audit.AuditRecordPublisher;
import java.util.function.Predicate;
import org.jooq.DSLContext;
import org.jooq.lambda.Seq;

public class PLContext {
    private final DSLContext dslContext;
    private final PersistenceLayerRetryer retryer;
    private final Predicate<Feature> featurePredicate;
    private final AuditRecordPublisher auditRecordPublisher;

    private PLContext(DSLContext dslContext, PersistenceLayerRetryer retryer, Predicate<Feature> featurePredicate, AuditRecordPublisher auditRecordPublisher) {
        this.dslContext = dslContext;
        this.retryer = retryer;
        this.featurePredicate = featurePredicate;
        this.auditRecordPublisher = auditRecordPublisher;
    }

    public DSLContext dslContext() {
        return this.dslContext;
    }

    public FeatureSet generateFeatureSet() {
        return new FeatureSet((Iterable<Feature>)Seq.of((Object[])Feature.values()).filter(this.featurePredicate));
    }

    public PersistenceLayerRetryer persistenceLayerRetryer() {
        return this.retryer;
    }

    public AuditRecordPublisher auditRecordPublisher() {
        return this.auditRecordPublisher;
    }

    public FetchFromStep select(EntityField<?, ?> ... fields) {
        return new FluentEntitiesFetcher(this.fetcher(), fields);
    }

    private EntitiesFetcher fetcher() {
        return new EntitiesFetcher(this.dslContext, this.generateFeatureSet());
    }

    public static class Builder {
        private DSLContext dslContext;
        private PersistenceLayerRetryer retryer = PersistenceLayerRetryer.JUST_RUN_WITHOUT_CHECKING_DEADLOCKS;
        private Predicate<Feature> featurePredicate = __ -> false;
        private AuditRecordPublisher auditRecordPublisher = AuditRecordPublisher.NO_OP;

        public Builder withFeaturePredicate(Predicate<Feature> featurePredicate) {
            this.featurePredicate = featurePredicate;
            return this;
        }

        public Builder(DSLContext dslContext) {
            this.dslContext = dslContext;
        }

        public Builder withRetryer(PersistenceLayerRetryer retryer) {
            this.retryer = retryer;
            return this;
        }

        public Builder withAuditRecordPublisher(AuditRecordPublisher auditRecordPublisher) {
            this.auditRecordPublisher = auditRecordPublisher;
            return this;
        }

        public PLContext build() {
            return new PLContext(this.dslContext, this.retryer, this.featurePredicate, this.auditRecordPublisher);
        }
    }
}

