/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeContextImpl;
import com.kenshoo.pl.entity.ChangeEntityCommand;
import com.kenshoo.pl.entity.ChangeFlowConfig;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.CreateEntityCommand;
import com.kenshoo.pl.entity.CreateResult;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.DeleteEntityCommand;
import com.kenshoo.pl.entity.DeleteResult;
import com.kenshoo.pl.entity.DeletionCommandPopulator;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityChangeResult;
import com.kenshoo.pl.entity.EntityCreateResult;
import com.kenshoo.pl.entity.EntityDeleteResult;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityInsertOnDuplicateUpdateResult;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.EntityUpdateResult;
import com.kenshoo.pl.entity.FeatureSet;
import com.kenshoo.pl.entity.FieldsToFetchBuilder;
import com.kenshoo.pl.entity.FieldsValueMap;
import com.kenshoo.pl.entity.Hierarchy;
import com.kenshoo.pl.entity.HierarchyKeyPopulator;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.InsertOnDuplicateUpdateCommand;
import com.kenshoo.pl.entity.InsertOnDuplicateUpdateResult;
import com.kenshoo.pl.entity.OverridingContext;
import com.kenshoo.pl.entity.PLContext;
import com.kenshoo.pl.entity.UniqueKey;
import com.kenshoo.pl.entity.UpdateEntityCommand;
import com.kenshoo.pl.entity.UpdateResult;
import com.kenshoo.pl.entity.ValidationError;
import com.kenshoo.pl.entity.audit.AuditRecord;
import com.kenshoo.pl.entity.internal.ChangesFilter;
import com.kenshoo.pl.entity.internal.EntitiesFetcher;
import com.kenshoo.pl.entity.internal.EntitiesToContextFetcher;
import com.kenshoo.pl.entity.internal.RequiredFieldsChangesFilter;
import com.kenshoo.pl.entity.internal.audit.RecursiveAuditRecordGenerator;
import com.kenshoo.pl.entity.internal.validators.ValidationFilter;
import com.kenshoo.pl.entity.spi.CurrentStateConsumer;
import com.kenshoo.pl.entity.spi.OutputGenerator;
import com.kenshoo.pl.entity.spi.ValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.lambda.Seq;

public class PersistenceLayer<ROOT extends EntityType<ROOT>> {
    private final PLContext plContext;
    private final FieldsToFetchBuilder<ROOT> fieldsToFetchBuilder;
    private DeletionCommandPopulator deletionCommandPopulator;
    private final RecursiveAuditRecordGenerator recursiveAuditRecordGenerator;

    public PersistenceLayer(DSLContext dslContext) {
        this(new PLContext.Builder(dslContext).build());
    }

    public PersistenceLayer(PLContext plContext) {
        this.plContext = plContext;
        this.fieldsToFetchBuilder = new FieldsToFetchBuilder();
        this.deletionCommandPopulator = new DeletionCommandPopulator(plContext);
        this.recursiveAuditRecordGenerator = new RecursiveAuditRecordGenerator();
    }

    public <PK extends Identifier<ROOT>> CreateResult<ROOT, PK> create(Collection<? extends CreateEntityCommand<ROOT>> commands, ChangeFlowConfig<ROOT> flowConfig, UniqueKey<ROOT> primaryKey) {
        ChangeContext changeContext = this.makeChanges(commands, flowConfig);
        CreateResult<ROOT, PK> results = this.toCreateResults(commands, changeContext);
        this.setIdentifiersToSuccessfulCommands(flowConfig, primaryKey, changeContext, results);
        return results;
    }

    public CreateResult<ROOT, Identifier<ROOT>> create(Collection<? extends CreateEntityCommand<ROOT>> commands, ChangeFlowConfig<ROOT> flowConfig) {
        return this.create(commands, flowConfig, flowConfig.getEntityType().getPrimaryKey());
    }

    private <PK extends Identifier<ROOT>> void setIdentifiersToSuccessfulCommands(ChangeFlowConfig<ROOT> flowConfig, UniqueKey<ROOT> primaryKey, ChangeContext changeContext, CreateResult<ROOT, PK> results) {
        Optional<EntityField<ROOT, Object>> optionalIdentityField = flowConfig.getPrimaryIdentityField();
        Seq.seq(results.iterator()).filter(EntityChangeResult::isSuccess).map(EntityChangeResult::getCommand).forEach(cmd -> {
            optionalIdentityField.ifPresent(idField -> this.populateIdentityField((ChangeEntityCommand<ROOT>)cmd, changeContext, (EntityField<ROOT, Object>)idField));
            cmd.setIdentifier(primaryKey.createIdentifier((FieldsValueMap<ROOT>)cmd));
        });
    }

    private <PK extends Identifier<ROOT>> CreateResult<ROOT, PK> toCreateResults(Collection<? extends CreateEntityCommand<ROOT>> commands, ChangeContext changeContext) {
        return new CreateResult(Seq.seq(commands).map(cmd -> new EntityCreateResult(cmd, (Iterable<ValidationError>)changeContext.getValidationErrors((EntityChange)cmd))), changeContext.getStats());
    }

    public <ID extends Identifier<ROOT>> UpdateResult<ROOT, ID> update(Collection<? extends UpdateEntityCommand<ROOT, ID>> commands, ChangeFlowConfig<ROOT> flowConfig) {
        ChangeContext changeContext = this.makeChanges(commands, flowConfig);
        return new UpdateResult(Seq.seq(commands).map(cmd -> new EntityUpdateResult(cmd, (Iterable<ValidationError>)changeContext.getValidationErrors((EntityChange)cmd))), changeContext.getStats());
    }

    public <ID extends Identifier<ROOT>> DeleteResult<ROOT, ID> delete(Collection<? extends DeleteEntityCommand<ROOT, ID>> commands, ChangeFlowConfig<ROOT> flowConfig) {
        ChangeContext changeContext = this.makeChanges(commands, flowConfig);
        return new DeleteResult(Seq.seq(commands).map(cmd -> new EntityDeleteResult(cmd, (Iterable<ValidationError>)changeContext.getValidationErrors((EntityChange)cmd))), changeContext.getStats());
    }

    public <ID extends Identifier<ROOT>> InsertOnDuplicateUpdateResult<ROOT, ID> upsert(Collection<? extends InsertOnDuplicateUpdateCommand<ROOT, ID>> commands, ChangeFlowConfig<ROOT> flowConfig) {
        ChangeContext changeContext = this.makeChanges(commands, flowConfig);
        InsertOnDuplicateUpdateResult<ROOT, ID> results = this.toUpsertResults(commands, changeContext);
        this.populateIdentityFieldToSuccessfulUpserts(flowConfig, changeContext, results);
        return results;
    }

    private <ID extends Identifier<ROOT>> InsertOnDuplicateUpdateResult<ROOT, ID> toUpsertResults(Collection<? extends InsertOnDuplicateUpdateCommand<ROOT, ID>> commands, ChangeContext changeContext) {
        return new InsertOnDuplicateUpdateResult(Seq.seq(commands).map(cmd -> new EntityInsertOnDuplicateUpdateResult(cmd, (Iterable<ValidationError>)changeContext.getValidationErrors((EntityChange)cmd))), changeContext.getStats());
    }

    private <ID extends Identifier<ROOT>> void populateIdentityFieldToSuccessfulUpserts(ChangeFlowConfig<ROOT> flowConfig, ChangeContext changeContext, InsertOnDuplicateUpdateResult<ROOT, ID> results) {
        flowConfig.getPrimaryIdentityField().ifPresent(identityField -> Seq.seq(results.iterator()).filter(EntityChangeResult::isSuccess).map(EntityChangeResult::getCommand).filter(cmd -> cmd.getChangeOperation() == ChangeOperation.CREATE).forEach(cmd -> this.populateIdentityField((ChangeEntityCommand<ROOT>)cmd, changeContext, (EntityField<ROOT, Object>)identityField)));
    }

    private ChangeContext makeChanges(Collection<? extends ChangeEntityCommand<ROOT>> commands, ChangeFlowConfig<ROOT> flowConfig) {
        this.deletionCommandPopulator.handleRecursive(commands, flowConfig);
        ChangeContextImpl context = new ChangeContextImpl(Hierarchy.build(flowConfig), flowConfig.getFeatures());
        context.addFetchRequests(this.fieldsToFetchBuilder.build(commands, flowConfig));
        this.prepareRecursive(commands, context, flowConfig);
        List validCmds = Seq.seq(commands).filter(cmd -> !context.containsError((EntityChange)cmd)).toList();
        OverridingContext overridingCtx = new OverridingContext(context);
        if (!validCmds.isEmpty()) {
            flowConfig.retryer().run(() -> this.dslContext().transaction(configuration -> this.generateOutputRecursive(flowConfig, validCmds, overridingCtx)));
        }
        Stream<AuditRecord> auditRecords = this.recursiveAuditRecordGenerator.generateMany(flowConfig, validCmds.stream(), overridingCtx);
        this.plContext.auditRecordPublisher().publish(auditRecords);
        return overridingCtx;
    }

    private <E extends EntityType<E>> void prepareRecursive(Collection<? extends ChangeEntityCommand<E>> commands, ChangeContext context, ChangeFlowConfig<E> flow) {
        this.prepareOneLayer(this.only(commands, this.withOperator(ChangeOperation.DELETE)), ChangeOperation.DELETE, context, flow);
        this.prepareOneLayer(this.only(commands, this.withOperator(ChangeOperation.UPDATE)), ChangeOperation.UPDATE, context, flow);
        commands.stream().filter(cmd -> cmd.allowMissingEntity() && this.isMissing((ChangeEntityCommand<?>)cmd, context)).forEach(cmd -> cmd.updateOperator(ChangeOperation.CREATE));
        this.prepareOneLayer(this.only(commands, this.withOperator(ChangeOperation.CREATE)), ChangeOperation.CREATE, context, flow);
        List validChanges = Seq.seq(commands).filter(cmd -> !context.containsErrorNonRecursive((EntityChange)cmd)).toList();
        this.populateParentKeysIntoChildren(context, validChanges);
        flow.childFlows().forEach(childFlow -> this.prepareChildFlowRecursive(validChanges, (ChangeFlowConfig)childFlow, context));
    }

    private <E extends EntityType<E>> void populateParentKeysIntoChildren(ChangeContext context, Collection<? extends ChangeEntityCommand<E>> commands) {
        new HierarchyKeyPopulator.Builder().with(context.getHierarchy()).whereParentFieldsAre(HierarchyKeyPopulator.notAutoInc()).gettingValues(HierarchyKeyPopulator.fromCommands()).build().populateKeysToChildren(this.only(commands, this.withOperator(ChangeOperation.CREATE)));
        new HierarchyKeyPopulator.Builder().with(context.getHierarchy()).whereParentFieldsAre(HierarchyKeyPopulator.anyField()).gettingValues(HierarchyKeyPopulator.fromContext(context)).build().populateKeysToChildren(this.only(commands, this.withOperator(ChangeOperation.UPDATE)));
    }

    private <PARENT extends EntityType<PARENT>, CHILD extends EntityType<CHILD>> void prepareChildFlowRecursive(List<? extends ChangeEntityCommand<PARENT>> validChanges, ChangeFlowConfig<CHILD> childFlow, ChangeContext context) {
        this.prepareRecursive(validChanges.stream().flatMap(parent -> parent.getChildren(childFlow.getEntityType())).collect(Collectors.toList()), context, childFlow);
    }

    private boolean isMissing(ChangeEntityCommand<?> cmd, ChangeContext context) {
        return context.getEntity(cmd) == CurrentEntityState.EMPTY;
    }

    private <E extends EntityType<E>> Collection<EntityChange<E>> prepareOneLayer(Collection<? extends ChangeEntityCommand<E>> commands, ChangeOperation changeOperation, ChangeContext changeContext, ChangeFlowConfig<E> flowConfig) {
        if (commands.isEmpty()) {
            return Collections.emptyList();
        }
        if (!flowConfig.getEntityType().getSupportedOperation().supports(changeOperation)) {
            throw new IllegalStateException("Operation " + changeOperation + " is not supported by entity type");
        }
        if ((commands = this.filterCommands(commands, flowConfig, changeOperation, changeContext)).isEmpty()) {
            return Collections.emptyList();
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.fetcher(flowConfig.getFeatures()).fetchEntities(commands, changeOperation, changeContext, flowConfig);
        changeContext.getStats().addFetchTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        commands = this.filterCommands(commands, this.getSupportedFilters(flowConfig.getPostFetchFilters(), changeOperation), changeOperation, changeContext);
        commands = this.resolveSuppliersAndFilterErrors(commands, changeContext);
        commands = this.filterCommands(commands, this.getSupportedFilters(flowConfig.getPostSupplyFilters(), changeOperation), changeOperation, changeContext);
        this.enrichCommandsPostFetch(commands, flowConfig, changeOperation, changeContext);
        return this.validateChanges(commands, new ValidationFilter<E>(flowConfig.getValidators()), changeOperation, changeContext);
    }

    private <E extends EntityType<E>> EntitiesToContextFetcher fetcher(FeatureSet features) {
        return new EntitiesToContextFetcher(new EntitiesFetcher(this.dslContext(), features));
    }

    private <E extends EntityType<E>, C extends ChangeEntityCommand<E>> Collection<C> resolveSuppliersAndFilterErrors(Collection<C> commands, ChangeContext changeContext) {
        ArrayList validCommands = Lists.newArrayListWithCapacity((int)commands.size());
        for (ChangeEntityCommand command : commands) {
            CurrentEntityState currentState = changeContext.getEntity(command);
            try {
                command.resolveSuppliers(currentState);
                validCommands.add(command);
            }
            catch (ValidationException e) {
                changeContext.addValidationError(command, e.getValidationError());
            }
        }
        return validCommands;
    }

    private <E extends EntityType<E>, C extends ChangeEntityCommand<E>> Collection<C> filterCommands(Collection<C> commands, ChangeFlowConfig<E> flowConfig, ChangeOperation changeOperation, ChangeContext changeContext) {
        if (changeOperation == ChangeOperation.CREATE) {
            return Lists.newArrayList((Iterable)new RequiredFieldsChangesFilter<E>(flowConfig.getRequiredRelationFields()).filter(commands, changeOperation, changeContext));
        }
        return commands;
    }

    private <E extends EntityType<E>> void enrichCommandsPostFetch(Collection<? extends ChangeEntityCommand<E>> commands, ChangeFlowConfig<E> flowConfig, ChangeOperation changeOperation, ChangeContext changeContext) {
        flowConfig.getPostFetchCommandEnrichers().stream().filter(CurrentStateConsumer.supporting(changeOperation)).forEach(enricher -> enricher.enrich(commands, changeOperation, changeContext));
    }

    private <E extends EntityType<E>> List<ChangesFilter<E>> getSupportedFilters(List<ChangesFilter<E>> filters, ChangeOperation changeOperation) {
        return filters.stream().filter(CurrentStateConsumer.supporting(changeOperation)).collect(Collectors.toList());
    }

    private <E extends EntityType<E>, T extends ChangeEntityCommand<E>> Collection<T> filterCommands(Collection<T> changes, List<ChangesFilter<E>> changesFilters, ChangeOperation changeOperation, ChangeContext changeContext) {
        Object filteredChanges = ImmutableList.copyOf(changes);
        for (ChangesFilter<E> changesFilter : changesFilters) {
            filteredChanges = Lists.newArrayList(changesFilter.filter(filteredChanges, changeOperation, changeContext));
        }
        return filteredChanges;
    }

    private <E extends EntityType<E>> Collection<EntityChange<E>> validateChanges(Collection<? extends ChangeEntityCommand<E>> changes, ChangesFilter<E> validationFilter, ChangeOperation changeOperation, ChangeContext changeContext) {
        return Lists.newArrayList(validationFilter.filter(changes, changeOperation, changeContext));
    }

    private <E extends EntityType<E>> void generateOutputRecursive(ChangeFlowConfig<E> flowConfig, Collection<? extends ChangeEntityCommand<E>> commands, ChangeContext context) {
        for (OutputGenerator outputGenerator : flowConfig.getOutputGenerators()) {
            Seq.of((Object[])new ChangeOperation[]{ChangeOperation.DELETE, ChangeOperation.UPDATE, ChangeOperation.CREATE}).filter(CurrentStateConsumer.supporting(outputGenerator)).map(op -> Seq.seq((Iterable)commands).filter(cmd -> cmd.getChangeOperation() == op).toList()).filter(list -> !list.isEmpty()).forEach(list -> outputGenerator.generate((Collection)list, ((ChangeEntityCommand)list.get(0)).getChangeOperation(), context));
        }
        flowConfig.childFlows().forEach(childFlow -> this.generateOutputChildFlowRecursive(commands, (ChangeFlowConfig)childFlow, context));
    }

    private <PARENT extends EntityType<PARENT>, CHILD extends EntityType<CHILD>> void generateOutputChildFlowRecursive(Collection<? extends ChangeEntityCommand<PARENT>> entityChanges, ChangeFlowConfig<CHILD> childFlow, ChangeContext context) {
        this.generateOutputRecursive(childFlow, entityChanges.stream().flatMap(parent -> parent.getChildren(childFlow.getEntityType())).collect(Collectors.toList()), context);
    }

    private <T> List<? extends T> only(Iterable<? extends T> items, Predicate<? super T> predicate) {
        return Seq.seq(items).filter(predicate).toList();
    }

    private Predicate<? super EntityChange<?>> withOperator(ChangeOperation op) {
        return cmd -> op == cmd.getChangeOperation();
    }

    private void populateIdentityField(ChangeEntityCommand<ROOT> cmd, ChangeContext changeContext, EntityField<ROOT, Object> idField) {
        CurrentEntityState currentState = Optional.ofNullable(changeContext.getEntity(cmd)).orElseThrow(() -> new IllegalStateException("Could not find entity of command in the change context"));
        cmd.set(idField, currentState.get(idField));
    }

    private DSLContext dslContext() {
        return this.plContext.dslContext();
    }
}

