/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.audit;

import com.kenshoo.pl.entity.EntityField;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class FieldAuditRecord {
    private final String field;
    private final String oldValue;
    private final String newValue;

    private FieldAuditRecord(String field, String oldValue, String newValue) {
        this.field = field;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getField() {
        return this.field;
    }

    public Optional<String> getOldValue() {
        return Optional.ofNullable(this.oldValue);
    }

    public Optional<String> getNewValue() {
        return Optional.ofNullable(this.newValue);
    }

    public static Builder builder(EntityField<?, ?> field) {
        return new Builder(field.toString());
    }

    public static Builder builder(String field) {
        return new Builder(field);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldAuditRecord that = (FieldAuditRecord)o;
        return new EqualsBuilder().append((Object)this.field, (Object)that.field).append((Object)this.oldValue, (Object)that.oldValue).append((Object)this.newValue, (Object)that.newValue).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.field).append((Object)this.oldValue).append((Object)this.newValue).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("field", (Object)this.field).append("oldValue", (Object)this.oldValue).append("newValue", (Object)this.newValue).toString();
    }

    public static class Builder {
        private final String field;
        private String oldValue;
        private String newValue;

        private Builder(String field) {
            this.field = Objects.requireNonNull(field, "A field is required");
        }

        public Builder oldValue(String oldValue) {
            this.oldValue = oldValue;
            return this;
        }

        public Builder newValue(String newValue) {
            this.newValue = newValue;
            return this;
        }

        public FieldAuditRecord build() {
            return new FieldAuditRecord(this.field, this.oldValue, this.newValue);
        }
    }
}

