/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal;

import com.kenshoo.jooq.DataTable;
import com.kenshoo.pl.data.AbstractRecordCommand;
import com.kenshoo.pl.data.AffectedRows;
import com.kenshoo.pl.data.CommandsExecutor;
import com.kenshoo.pl.data.CreateRecordCommand;
import com.kenshoo.pl.data.DeleteRecordCommand;
import com.kenshoo.pl.data.UpdateRecordCommand;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.PersistentLayerStats;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class ChangesContainer {
    private final CreateRecordCommand.OnDuplicateKey onDuplicateKey;
    private final Map<DataTable, IdToCommandMap<DeleteRecordCommand>> deletes = new HashMap<DataTable, IdToCommandMap<DeleteRecordCommand>>();
    private final Map<DataTable, IdToCommandMap<UpdateRecordCommand>> updates = new HashMap<DataTable, IdToCommandMap<UpdateRecordCommand>>();
    private final Map<DataTable, IdToCommandMap<CreateRecordCommand>> inserts = new HashMap<DataTable, IdToCommandMap<CreateRecordCommand>>();
    private final Map<DataTable, IdToCommandMap<CreateRecordCommand>> insertsOnDuplicateUpdate = new HashMap<DataTable, IdToCommandMap<CreateRecordCommand>>();

    public ChangesContainer(CreateRecordCommand.OnDuplicateKey onDuplicateKey) {
        this.onDuplicateKey = onDuplicateKey;
    }

    public AbstractRecordCommand getDelete(DataTable table, EntityChange entityChange, Supplier<DeleteRecordCommand> commandCreator) {
        return this.getOrCreate(this.deletes, () -> new IdToCommandMap(), commandCreator, table, entityChange);
    }

    public AbstractRecordCommand getUpdate(DataTable table, EntityChange entityChange, Supplier<UpdateRecordCommand> commandCreator) {
        return this.getOrCreate(this.updates, () -> new IdToCommandMap(), commandCreator, table, entityChange);
    }

    public AbstractRecordCommand getInsert(DataTable table, EntityChange entityChange, Supplier<CreateRecordCommand> commandCreator) {
        return this.getOrCreate(this.inserts, () -> new IdToCommandMap(), commandCreator, table, entityChange);
    }

    public Optional<CreateRecordCommand> getInsert(DataTable table, EntityChange entityChange) {
        return Optional.ofNullable(this.inserts.get(table)).map(idToCmdMap -> (CreateRecordCommand)idToCmdMap.get(entityChange));
    }

    public AbstractRecordCommand getInsertOnDuplicateUpdate(DataTable table, EntityChange entityChange, Supplier<CreateRecordCommand> commandCreator) {
        return this.getOrCreate(this.insertsOnDuplicateUpdate, () -> new IdToCommandMap(), commandCreator, table, entityChange);
    }

    public void commit(CommandsExecutor commandsExecutor, PersistentLayerStats stats) {
        AffectedRows affectedRows;
        DataTable table;
        for (Map.Entry<DataTable, IdToCommandMap<DeleteRecordCommand>> entry : this.deletes.entrySet()) {
            table = entry.getKey();
            affectedRows = commandsExecutor.executeDeletes(table, entry.getValue().map.values());
            stats.addAffectedRows(table.getName(), affectedRows);
        }
        for (Map.Entry<DataTable, IdToCommandMap<AbstractRecordCommand>> entry : this.inserts.entrySet()) {
            AffectedRows affectedRows2;
            table = entry.getKey();
            Collection commands = entry.getValue().map.values();
            switch (this.onDuplicateKey) {
                case IGNORE: {
                    AffectedRows affectedRows22 = commandsExecutor.executeInsertsOnDuplicateKeyIgnore(table, commands);
                    break;
                }
                case UPDATE: {
                    affectedRows2 = commandsExecutor.executeInsertsOnDuplicateKeyUpdate(table, commands);
                    break;
                }
                default: {
                    affectedRows2 = commandsExecutor.executeInserts(table, commands);
                }
            }
            stats.addAffectedRows(table.getName(), affectedRows2);
        }
        for (Map.Entry<DataTable, IdToCommandMap<AbstractRecordCommand>> entry : this.updates.entrySet()) {
            table = entry.getKey();
            affectedRows = commandsExecutor.executeUpdates(table, entry.getValue().map.values());
            stats.addAffectedRows(table.getName(), affectedRows);
        }
        for (Map.Entry<DataTable, IdToCommandMap<AbstractRecordCommand>> entry : this.insertsOnDuplicateUpdate.entrySet()) {
            table = entry.getKey();
            affectedRows = commandsExecutor.executeInsertsOnDuplicateKeyUpdate(table, entry.getValue().map.values());
            stats.addAffectedRows(table.getName(), affectedRows);
        }
    }

    private <RC extends AbstractRecordCommand> AbstractRecordCommand getOrCreate(Map<DataTable, IdToCommandMap<RC>> map, Supplier<IdToCommandMap<RC>> creator, Supplier<RC> commandCreator, DataTable table, EntityChange entityChange) {
        IdToCommandMap idToCommandMap = map.computeIfAbsent(table, k -> (IdToCommandMap)creator.get());
        return idToCommandMap.getOrCreate(entityChange, commandCreator);
    }

    private static class IdToCommandMap<RC extends AbstractRecordCommand> {
        private final Map<EntityChange, RC> map = new HashMap<EntityChange, RC>();

        private IdToCommandMap() {
        }

        AbstractRecordCommand getOrCreate(EntityChange entityChange, Supplier<RC> commandCreator) {
            return this.map.computeIfAbsent(entityChange, k -> (AbstractRecordCommand)commandCreator.get());
        }

        RC get(EntityChange entityChange) {
            return (RC)((AbstractRecordCommand)this.map.get(entityChange));
        }
    }
}

