/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal;

import com.google.common.collect.Iterables;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FullIdentifier;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.IdentifierType;
import com.kenshoo.pl.entity.PLCondition;
import com.kenshoo.pl.entity.PLContext;
import com.kenshoo.pl.entity.UniqueKey;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public class ChildrenIdFetcher<PARENT extends EntityType<PARENT>, CHILD extends EntityType<CHILD>> {
    private final PLContext plContext;

    public ChildrenIdFetcher(PLContext plContext) {
        this.plContext = plContext;
    }

    public Stream<FullIdentifier<PARENT, CHILD>> fetch(Collection<? extends Identifier<PARENT>> parentIds, IdentifierType<CHILD> childKey) {
        if (parentIds.isEmpty()) {
            return Stream.empty();
        }
        PARENT parentType = this.first(parentIds).getUniqueKey().getEntityType();
        CHILD childType = childKey.getEntityType();
        EntityType.ForeignKey keyToParent = childType.getKeyTo(parentType);
        IdentifierType<PARENT> parentKey = this.first(parentIds).getUniqueKey();
        UniqueKey childFK = new UniqueKey(keyToParent.from());
        EntityField[] requestedFields = (EntityField[])Iterables.toArray((Iterable)Seq.concat((Seq[])new Seq[]{Seq.of((Object[])parentKey.getFields()), Seq.of((Object[])childKey.getFields()), Seq.of((Object[])childFK.getFields())}), EntityField.class);
        List<CurrentEntityState> entities = this.plContext.select(requestedFields).from((EntityType<?>)childType).where(PLCondition.trueCondition()).fetchByKeys(parentIds);
        return this.fullIdentifierOf(entities, parentKey, childKey, childFK);
    }

    private Stream<FullIdentifier<PARENT, CHILD>> fullIdentifierOf(List<CurrentEntityState> entities, IdentifierType<PARENT> parentKey, IdentifierType<CHILD> childKey, UniqueKey<CHILD> childFK) {
        return Seq.seq(entities).map(entity -> new FullIdentifier(this.parse((IdentifierType)parentKey, (CurrentEntityState)entity), this.parse((IdentifierType)childKey, (CurrentEntityState)entity), this.parse((IdentifierType)childFK, (CurrentEntityState)entity)));
    }

    private <T extends EntityType<T>> Identifier<T> parse(IdentifierType<T> key, CurrentEntityState entity) {
        return key.createIdentifier(entity);
    }

    private <T> T first(Collection<T> collection) {
        return collection.iterator().next();
    }
}

