/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal;

import com.google.common.base.Stopwatch;
import com.kenshoo.jooq.DataTable;
import com.kenshoo.pl.data.AbstractRecordCommand;
import com.kenshoo.pl.data.CommandsExecutor;
import com.kenshoo.pl.data.CreateRecordCommand;
import com.kenshoo.pl.data.DatabaseId;
import com.kenshoo.pl.data.DeleteRecordCommand;
import com.kenshoo.pl.data.UpdateRecordCommand;
import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeEntityCommand;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FieldChange;
import com.kenshoo.pl.entity.FieldFetchRequest;
import com.kenshoo.pl.entity.HierarchyKeyPopulator;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.PLContext;
import com.kenshoo.pl.entity.internal.ChangesContainer;
import com.kenshoo.pl.entity.internal.EntityDbUtil;
import com.kenshoo.pl.entity.internal.EntityWithGeneratedId;
import com.kenshoo.pl.entity.internal.SecondaryTableRelationExtractor;
import com.kenshoo.pl.entity.spi.OutputGenerator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jooq.ForeignKey;
import org.jooq.Record;
import org.jooq.TableField;
import org.jooq.lambda.Seq;
import org.jooq.lambda.function.Functions;

public class DbCommandsOutputGenerator<E extends EntityType<E>>
implements OutputGenerator<E> {
    private final E entityType;
    private final CommandsExecutor commandsExecutor;

    public DbCommandsOutputGenerator(E entityType, PLContext plContext) {
        this.entityType = entityType;
        this.commandsExecutor = CommandsExecutor.of(plContext.dslContext());
    }

    @Override
    public void generate(Collection<? extends EntityChange<E>> entityChanges, ChangeOperation operator, ChangeContext changeContext) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (operator == ChangeOperation.DELETE) {
            this.generateForDelete(changeContext, entityChanges);
        } else {
            ChangesContainer primaryTableCommands = this.generateForCreateOrUpdate(entityChanges, this::isOfPrimaryTable, operator, changeContext);
            this.entityType.getPrimaryIdentityField().ifPresent(identityField -> {
                if (operator == ChangeOperation.CREATE) {
                    this.populateGeneratedIdsToContext((EntityField<E, Object>)identityField, entityChanges, changeContext, primaryTableCommands);
                    new HierarchyKeyPopulator.Builder().with(changeContext.getHierarchy()).whereParentFieldsAre(HierarchyKeyPopulator.autoInc()).gettingValues(HierarchyKeyPopulator.fromContext(changeContext)).build().populateKeysToChildren(entityChanges);
                }
            });
            this.generateForCreateOrUpdate(entityChanges, Functions.not(this::isOfPrimaryTable), operator, changeContext);
        }
        changeContext.getStats().addUpdateTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private void populateGeneratedIdsToContext(EntityField<E, Object> identityField, Collection<? extends EntityChange<E>> entityChanges, ChangeContext changeContext, ChangesContainer changesContainer) {
        TableField<Record, ?> identityTableField = this.getFirstTableField(identityField);
        Seq.seq(entityChanges).map(change -> ImmutablePair.of((Object)change, changesContainer.getInsert(this.entityType.getPrimaryTable(), (EntityChange)change))).filter(pair -> ((Optional)pair.getRight()).isPresent()).forEach(pair -> {
            CreateRecordCommand cmd = (CreateRecordCommand)((Optional)pair.getRight()).get();
            Object generatedValue = cmd.get(identityTableField);
            changeContext.addEntity((EntityChange)pair.getLeft(), new EntityWithGeneratedId(identityField, generatedValue));
        });
    }

    private TableField<Record, ?> getFirstTableField(EntityField<E, Object> entityField) {
        return entityField.getDbAdapter().getTableFields().findFirst().orElseThrow(() -> new IllegalStateException("No table fields found for an entity field"));
    }

    private boolean isOfPrimaryTable(FieldChange<E, ?> f) {
        return f.getField().getDbAdapter().getTable() == this.entityType.getPrimaryTable();
    }

    private <T> void translateChange(EntityChange<E> entityChange, FieldChange<E, T> change, ChangesContainer changesContainer, ChangeOperation changeOperation, ChangeContext changeContext) {
        EntityField<E, T> entityField = change.getField();
        if (!entityField.isVirtual()) {
            this.translateChange(entityChange, change, entityField, changesContainer, changeOperation, changeContext);
        }
    }

    private <T> void translateChange(EntityChange<E> entityChange, FieldChange<E, T> change, EntityField<E, T> entityField, ChangesContainer changesContainer, ChangeOperation operator, ChangeContext ctx) {
        AbstractRecordCommand recordCommand;
        DataTable primaryTable;
        DataTable fieldTable = entityField.getDbAdapter().getTable();
        if (fieldTable == (primaryTable = this.entityType.getPrimaryTable())) {
            recordCommand = operator == ChangeOperation.CREATE ? changesContainer.getInsert(primaryTable, entityChange, () -> this.newCreateRecord(entityChange)) : changesContainer.getUpdate(primaryTable, entityChange, () -> new UpdateRecordCommand(primaryTable, this.getDatabaseId(entityChange)));
        } else {
            DatabaseId foreignKeyValues = this.foreignKeyValues(entityChange, operator, ctx, fieldTable);
            recordCommand = operator == ChangeOperation.CREATE || this.rowNotYetExistsInSecondary(fieldTable, ctx.getEntity(entityChange), ctx, foreignKeyValues) ? changesContainer.getInsertOnDuplicateUpdate(fieldTable, entityChange, () -> {
                CreateRecordCommand createRecordCommand = new CreateRecordCommand(fieldTable);
                this.populate(foreignKeyValues, createRecordCommand);
                return createRecordCommand;
            }) : changesContainer.getUpdate(fieldTable, entityChange, () -> new UpdateRecordCommand(fieldTable, foreignKeyValues));
        }
        this.populateFieldChange(change, recordCommand);
    }

    private boolean rowNotYetExistsInSecondary(DataTable table, CurrentEntityState fetchedFields, ChangeContext ctx, DatabaseId fkToPrimary) {
        EntityField keyFieldFromSecondaryToPrimary = (EntityField)Seq.seq(ctx.getFetchRequests()).map(FieldFetchRequest::getEntityField).filter(this.isTableFieldExistsIn(fkToPrimary)).findFirst(field -> field.getDbAdapter().getTable() == table).get();
        return fetchedFields.safeGet(keyFieldFromSecondaryToPrimary).isNullOrAbsent();
    }

    private Predicate<EntityField<?, ?>> isTableFieldExistsIn(DatabaseId fkToPrimary) {
        return field -> field.getDbAdapter().getTableFields().findFirst().map(tableField -> Seq.of((Object[])fkToPrimary.getTableFields()).contains(tableField)).orElse(false);
    }

    private CreateRecordCommand newCreateRecord(EntityChange<E> entityChange) {
        CreateRecordCommand cmd = new CreateRecordCommand(this.entityType.getPrimaryTable());
        this.populateParentKeys(entityChange, cmd);
        return cmd;
    }

    private <T> void populateFieldChange(FieldChange<?, T> change, AbstractRecordCommand recordCommand) {
        T value = change.getValue();
        Iterator tableFields = change.getField().getDbAdapter().getTableFields().iterator();
        Iterator values = change.getField().getDbAdapter().getDbValues(value).iterator();
        while (tableFields.hasNext()) {
            recordCommand.set((TableField)tableFields.next(), values.next());
        }
    }

    @Override
    public Stream<? extends EntityField<?, ?>> requiredFields(Collection<? extends EntityField<E, ?>> fieldsToUpdate, ChangeOperation changeOperation) {
        if (changeOperation != ChangeOperation.UPDATE) {
            return Stream.empty();
        }
        List secondaryTables = this.secondaryTables(fieldsToUpdate).collect(Collectors.toList());
        if (secondaryTables.isEmpty()) {
            return Stream.empty();
        }
        Stream<EntityField> secondaryTableFieldsThatCannotBeNull = secondaryTables.stream().map(table -> SecondaryTableRelationExtractor.relationUsingTableFieldsOfSecondary(table, this.entityType).findFirst().get());
        Stream requiredPrimaryTableIds = secondaryTables.stream().flatMap(table -> SecondaryTableRelationExtractor.relationUsingTableFieldsOfPrimary(table, this.entityType));
        return Stream.concat(secondaryTableFieldsThatCannotBeNull, requiredPrimaryTableIds);
    }

    private Stream<DataTable> secondaryTables(Collection<? extends EntityField<E, ?>> fieldsToUpdate) {
        return fieldsToUpdate.stream().filter(this::isSecondaryField).map(field -> field.getDbAdapter().getTable()).distinct();
    }

    private boolean isSecondaryField(EntityField<E, ?> field) {
        return field.getEntityType() == this.entityType && !this.entityType.getPrimaryTable().equals(field.getDbAdapter().getTable());
    }

    private void populate(DatabaseId id, AbstractRecordCommand toRecord) {
        for (int i = 0; i < id.getTableFields().length; ++i) {
            TableField<?, ?> field = id.getTableFields()[i];
            toRecord.set(field, id.getValues()[i]);
        }
    }

    private DatabaseId foreignKeyValues(EntityChange<E> cmd, ChangeOperation changeOperation, ChangeContext context, DataTable childTable) {
        Object[] values;
        ForeignKey<Record, Record> foreignKey = childTable.getForeignKey(this.entityType.getPrimaryTable());
        Collection<EntityField<E, ?>> parentFields = this.entityType(cmd).findFields(foreignKey.getKey().getFields());
        boolean hasIdentity = this.entityType.getPrimaryIdentityField().isPresent();
        Object[] objectArray = values = changeOperation == ChangeOperation.CREATE && !hasIdentity ? EntityDbUtil.getFieldValues(parentFields, cmd) : EntityDbUtil.getFieldValues(parentFields, context.getEntity(cmd));
        if (foreignKey.getFields().size() != values.length) {
            throw new IllegalStateException("Foreign key from " + childTable.getName() + " doesn't have the same number of fields as " + foreignKey);
        }
        return new DatabaseId(foreignKey.getFields().toArray(new TableField[foreignKey.getFields().size()]), values);
    }

    private EntityType<E> entityType(EntityChange<E> cmd) {
        return ((ChangeEntityCommand)cmd).getEntityType();
    }

    private void populateParentKeys(EntityChange<E> entityChange, AbstractRecordCommand recordCommand) {
        if (entityChange.getKeysToParent() != null) {
            DatabaseId parentIdValues = EntityDbUtil.getDatabaseId(entityChange.getKeysToParent());
            this.populate(parentIdValues, recordCommand);
        }
    }

    private DatabaseId getDatabaseId(EntityChange<E> entityChange) {
        DatabaseId databaseId = EntityDbUtil.getDatabaseId(entityChange.getIdentifier());
        Identifier<E> keysToParent = entityChange.getKeysToParent();
        if (keysToParent != null) {
            databaseId = databaseId.append(EntityDbUtil.getDatabaseId(entityChange.getKeysToParent()));
        }
        return databaseId;
    }

    private void generateForDelete(ChangeContext changeContext, Iterable<? extends EntityChange<E>> entityChanges) {
        ChangesContainer changesContainer = new ChangesContainer(this.entityType.onDuplicateKey());
        entityChanges.forEach(entityChange -> changesContainer.getDelete(this.entityType.getPrimaryTable(), (EntityChange)entityChange, () -> new DeleteRecordCommand(this.entityType.getPrimaryTable(), this.getDatabaseId((EntityChange<E>)entityChange))));
        changesContainer.commit(this.commandsExecutor, changeContext.getStats());
    }

    private ChangesContainer generateForCreateOrUpdate(Iterable<? extends EntityChange<E>> entityChanges, Predicate<FieldChange<E, ?>> filter, ChangeOperation operator, ChangeContext changeContext) {
        ChangesContainer tableCommands = new ChangesContainer(this.entityType.onDuplicateKey());
        Seq.seq(entityChanges).forEach(cmd -> cmd.getChanges().filter(filter).forEach(fieldChange -> this.translateChange((EntityChange<E>)cmd, (FieldChange)fieldChange, tableCommands, operator, changeContext)));
        tableCommands.commit(this.commandsExecutor, changeContext.getStats());
        return tableCommands;
    }
}

