/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal;

import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeEntityCommand;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.SupportedChangeOperation;
import com.kenshoo.pl.entity.spi.PostFetchCommandEnricher;
import com.kenshoo.pl.entity.spi.helpers.CommandsFieldMatcher;
import java.util.Collection;
import java.util.stream.Stream;

public class DefaultFieldValueEnricher<E extends EntityType<E>, T>
implements PostFetchCommandEnricher<E> {
    private final EntityField<E, T> field;
    private final T defaultValue;

    public DefaultFieldValueEnricher(EntityField<E, T> field, T defaultValue) {
        this.field = field;
        this.defaultValue = defaultValue;
    }

    @Override
    public void enrich(Collection<? extends ChangeEntityCommand<E>> changeEntityCommands, ChangeOperation changeOperation, ChangeContext changeContext) {
        changeEntityCommands.stream().filter(command -> !command.isFieldChanged(this.field)).forEach(command -> command.set(this.field, this.defaultValue));
    }

    @Override
    public Stream<EntityField<E, ?>> fieldsToEnrich() {
        return Stream.of(this.field);
    }

    @Override
    public boolean shouldRun(Collection<? extends EntityChange<E>> changeEntityCommands) {
        return CommandsFieldMatcher.isAnyFieldMissingInAnyCommand(changeEntityCommands, this.field);
    }

    @Override
    public SupportedChangeOperation getSupportedChangeOperation() {
        return SupportedChangeOperation.CREATE;
    }
}

