/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.kenshoo.jooq.DataTable;
import com.kenshoo.jooq.QueryExtension;
import com.kenshoo.jooq.TempTableHelper;
import com.kenshoo.jooq.TempTableResource;
import com.kenshoo.pl.data.ImpersonatorTable;
import com.kenshoo.pl.entity.CurrentEntityMutableState;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FeatureSet;
import com.kenshoo.pl.entity.FieldsValueMap;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.IdentifierType;
import com.kenshoo.pl.entity.PLCondition;
import com.kenshoo.pl.entity.PartialEntity;
import com.kenshoo.pl.entity.UniqueKey;
import com.kenshoo.pl.entity.internal.EntityTypeReflectionUtil;
import com.kenshoo.pl.entity.internal.PartialEntityInvocationHandler;
import com.kenshoo.pl.entity.internal.fetch.AliasedKey;
import com.kenshoo.pl.entity.internal.fetch.ExecutionPlan;
import com.kenshoo.pl.entity.internal.fetch.QueryBuilder;
import com.kenshoo.pl.entity.internal.fetch.RecordReader;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.jooq.SelectField;
import org.jooq.SelectFinalStep;
import org.jooq.lambda.Seq;

public class EntitiesFetcher {
    private final DSLContext dslContext;
    private final FeatureSet features;

    public EntitiesFetcher(DSLContext dslContext) {
        this(dslContext, FeatureSet.EMPTY);
    }

    public EntitiesFetcher(DSLContext dslContext, FeatureSet features) {
        this.dslContext = dslContext;
        this.features = features;
    }

    public <E extends EntityType<E>> Map<Identifier<E>, CurrentEntityState> fetchEntitiesByIds(Collection<? extends Identifier<E>> ids, EntityField<?, ?> ... fieldsToFetchArgs) {
        return this.fetchEntitiesByIds(ids, (Collection<? extends EntityField<?, ?>>)ImmutableList.copyOf((Object[])fieldsToFetchArgs));
    }

    public <E extends EntityType<E>> Map<Identifier<E>, CurrentEntityState> fetchEntitiesByIds(Collection<? extends Identifier<E>> ids, Collection<? extends EntityField<?, ?>> fieldsToFetch) {
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        IdentifierType<E> uniqueKey = ids.iterator().next().getUniqueKey();
        AliasedKey<E> aliasedKey = new AliasedKey<E>(uniqueKey);
        return this.fetchEntities(uniqueKey.getEntityType().getPrimaryTable(), aliasedKey, fieldsToFetch, query -> query.whereIdsIn(ids));
    }

    public <E extends EntityType<E>> List<CurrentEntityState> fetch(EntityType<E> entityType, PLCondition plCondition, EntityField<?, ?> ... fieldsToFetch) {
        Objects.requireNonNull(entityType, "An entity type must be provided");
        Objects.requireNonNull(plCondition, "A condition must be provided");
        Validate.notEmpty((Object[])fieldsToFetch, (String)"There must be at least one field to fetch", (Object[])new Object[0]);
        AliasedKey<E> aliasedKey = new AliasedKey<E>(entityType.getPrimaryKey());
        List allFieldsToFetch = (List)Seq.concat((Seq[])new Seq[]{Seq.of((Object[])fieldsToFetch), Seq.seq(plCondition.getFields())}).distinct().collect(Collectors.toList());
        return Lists.newArrayList(this.fetchEntities(entityType.getPrimaryTable(), aliasedKey, allFieldsToFetch, query -> query.withCondition(plCondition.getJooqCondition())).values());
    }

    public List<CurrentEntityState> fetch(EntityType<?> entityType, Collection<? extends Identifier<?>> keys, PLCondition plCondition, EntityField<?, ?> ... fieldsToFetch) {
        Objects.requireNonNull(entityType, "An entity type must be provided");
        Validate.notEmpty(keys, (String)"There must be at least one keys to fetch", (Object[])new Object[0]);
        Objects.requireNonNull(plCondition, "A condition must be provided");
        Validate.notEmpty((Object[])fieldsToFetch, (String)"There must be at least one field to fetch", (Object[])new Object[0]);
        AliasedKey aliasedKey = new AliasedKey(entityType.getPrimaryKey());
        List allFieldsToFetch = (List)Seq.concat((Seq[])new Seq[]{Seq.of((Object[])fieldsToFetch), Seq.seq(plCondition.getFields()), this.fieldsOf(keys)}).distinct().collect(Collectors.toList());
        return Lists.newArrayList(this.fetchEntities(entityType.getPrimaryTable(), aliasedKey, allFieldsToFetch, query -> query.whereIdsIn(keys).withCondition(plCondition.getJooqCondition())).values());
    }

    public <E extends EntityType<E>> Map<Identifier<E>, CurrentEntityState> fetchEntitiesByForeignKeys(E entityType, UniqueKey<E> foreignUniqueKey, Collection<? extends Identifier<E>> keys, Collection<EntityField<?, ?>> fieldsToFetch) {
        try (TempTableResource<ImpersonatorTable> foreignKeysTable = this.createForeignKeysTable(entityType.getPrimaryTable(), foreignUniqueKey, keys);){
            AliasedKey<E> aliasedKey = new AliasedKey<E>(foreignUniqueKey, foreignKeysTable);
            DataTable startingTable = foreignKeysTable.getTable();
            Map<Identifier<E>, CurrentEntityState> map = this.fetchEntities(startingTable, aliasedKey, fieldsToFetch, QueryBuilder::withoutPartitions);
            return map;
        }
    }

    public <E extends EntityType<E>, PE extends PartialEntity, ID extends Identifier<E>> Map<ID, PE> fetchPartialEntities(E entityType, Collection<ID> ids, Class<PE> entityIface) {
        Map entityMethodsMap = EntityTypeReflectionUtil.getMethodsMap(entityType, entityIface);
        Map entitiesMap = this.fetchEntitiesByIds(ids, entityMethodsMap.values());
        return (Map)Seq.seq(ids).filter(entitiesMap::containsKey).collect(Collectors.toMap(Function.identity(), id -> this.createInstance(entityIface, entityMethodsMap, (CurrentEntityState)entitiesMap.get(id))));
    }

    public <E extends EntityType<E>, PE extends PartialEntity> List<PE> fetchByCondition(E entityType, Condition condition, Class<PE> entityIface) {
        Map entityMethodsMap = EntityTypeReflectionUtil.getMethodsMap(entityType, entityIface);
        AliasedKey<E> aliasedKey = new AliasedKey<E>(entityType.getPrimaryKey());
        Collection<CurrentEntityState> entities = this.fetchEntities(entityType.getPrimaryTable(), aliasedKey, entityMethodsMap.values(), query -> query.withCondition(condition)).values();
        return entities.stream().map(entity -> this.createInstance(entityIface, entityMethodsMap, (CurrentEntityState)entity)).collect(Collectors.toList());
    }

    private <E extends EntityType<E>> Map<Identifier<E>, CurrentEntityState> fetchEntities(DataTable startingTable, AliasedKey<E> aliasedKey, Collection<? extends EntityField<?, ?>> fieldsToFetch, Consumer<QueryBuilder<E>> queryModifier) {
        ExecutionPlan executionPlan = new ExecutionPlan(startingTable, fieldsToFetch);
        ExecutionPlan.OneToOnePlan oneToOnePlan = executionPlan.getOneToOnePlan();
        QueryBuilder mainQueryBuilder = new QueryBuilder(this.dslContext).selecting(this.selectFieldsOf(oneToOnePlan.getFields(), aliasedKey)).from(startingTable).innerJoin(oneToOnePlan.getPaths()).leftJoin(oneToOnePlan.getSecondaryTableRelations());
        queryModifier.accept(mainQueryBuilder);
        Map entities = this.fetchMainEntities(aliasedKey, oneToOnePlan, mainQueryBuilder);
        executionPlan.getManyToOnePlans().forEach(plan -> {
            QueryBuilder subQueryBuilder = new QueryBuilder(this.dslContext).selecting(this.selectFieldsOf(plan.getFields(), aliasedKey)).from(startingTable).innerJoin(plan.getPath());
            queryModifier.accept(subQueryBuilder);
            this.fetchAndPopulateSubEntities(aliasedKey, entities, (ExecutionPlan.ManyToOnePlan)plan, subQueryBuilder);
        });
        return entities;
    }

    private <E extends EntityType<E>, SUB extends EntityType<SUB>> void fetchAndPopulateSubEntities(AliasedKey<E> aliasedKey, Map<Identifier<E>, CurrentEntityState> entities, ExecutionPlan.ManyToOnePlan<SUB> plan, QueryBuilder<E> queryBuilder) {
        try (QueryExtension<SelectFinalStep<Record>> queryExtender = queryBuilder.build();){
            Map<Identifier<E>, List<FieldsValueMap<SUB>>> multiValuesMap = this.fetchMultiValuesMap((ResultQuery<Record>)((ResultQuery)queryExtender.getQuery()), aliasedKey, plan.getFields());
            multiValuesMap.forEach((id, multiValues) -> {
                Object subEntityType = this.entityTypeOf(plan.getFields());
                ((CurrentEntityMutableState)entities.get(id)).add(subEntityType, multiValues);
            });
        }
    }

    private <E extends EntityType<E>> Map<Identifier<E>, CurrentEntityState> fetchMainEntities(AliasedKey<E> aliasedKey, ExecutionPlan.OneToOnePlan oneToOnePlan, QueryBuilder<E> queryBuilder) {
        try (QueryExtension<SelectFinalStep<Record>> queryExtender = queryBuilder.build();){
            Map<Identifier<E>, CurrentEntityState> map = this.fetchEntitiesMap((ResultQuery<Record>)((ResultQuery)queryExtender.getQuery()), aliasedKey, oneToOnePlan.getFields());
            return map;
        }
    }

    private <E extends EntityType<E>> Map<Identifier<E>, CurrentEntityState> fetchEntitiesMap(ResultQuery<Record> query, AliasedKey<E> aliasedKey, List<? extends EntityField<?, ?>> fields) {
        return query.fetchMap(record -> RecordReader.createKey(record, aliasedKey), record -> RecordReader.createEntity(record, fields));
    }

    private <MAIN extends EntityType<MAIN>, SUB extends EntityType<SUB>> Map<Identifier<MAIN>, List<FieldsValueMap<SUB>>> fetchMultiValuesMap(ResultQuery<Record> query, AliasedKey<MAIN> aliasedKey, List<? extends EntityField<SUB, ?>> fields) {
        HashMap multiValuesMap = new HashMap();
        query.fetchInto(record -> {
            Identifier key = RecordReader.createKey(record, aliasedKey);
            multiValuesMap.computeIfAbsent(key, k -> Lists.newArrayList());
            ((List)multiValuesMap.get(key)).add(RecordReader.createFieldsValueMap(record, fields));
        });
        return multiValuesMap;
    }

    public <E extends EntityType<E>> TempTableResource<ImpersonatorTable> createForeignKeysTable(DataTable primaryTable, UniqueKey<E> foreignUniqueKey, Collection<? extends Identifier<E>> keys) {
        ImpersonatorTable impersonatorTable = new ImpersonatorTable(primaryTable);
        foreignUniqueKey.getTableFields().forEach(impersonatorTable::createField);
        return TempTableHelper.tempInMemoryTable(this.dslContext, impersonatorTable, batchBindStep -> {
            for (Identifier key : keys) {
                EntityField<E, ?>[] keyFields = foreignUniqueKey.getFields();
                ArrayList<Object> values = new ArrayList<Object>();
                for (EntityField field : keyFields) {
                    this.addToValues(key, field, values);
                }
                batchBindStep.bind(values.toArray());
            }
        });
    }

    private <E extends EntityType<E>, T> void addToValues(Identifier<E> key, EntityField<E, T> field, List<Object> values) {
        field.getDbAdapter().getDbValues(key.get(field)).forEach(values::add);
    }

    private <E extends EntityType<E>> List<SelectField<?>> selectFieldsOf(Collection<? extends EntityField<?, ?>> fields, AliasedKey<E> aliasedKey) {
        return this.dbFieldsOf(fields).concat(aliasedKey.aliasedFields()).toList();
    }

    private Seq<SelectField<?>> dbFieldsOf(Collection<? extends EntityField<?, ?>> fields) {
        return Seq.seq(fields).flatMap(field -> field.getDbAdapter().getTableFields());
    }

    private <E extends EntityType<E>> E entityTypeOf(Collection<? extends EntityField<E, ?>> fields) {
        return (E)((EntityField)Seq.seq(fields).findFirst().get()).getEntityType();
    }

    private Seq<EntityField<?, ?>> fieldsOf(Collection<? extends Identifier<?>> ids) {
        return Seq.of((Object[])ids.iterator().next().getUniqueKey().getFields());
    }

    private <E extends EntityType<E>, PE extends PartialEntity> PE createInstance(Class<PE> entityIface, Map<Method, EntityField<E, ?>> entityMethodsMap, CurrentEntityState currentState) {
        Class[] interfaces = new Class[]{entityIface};
        return (PE)((PartialEntity)Proxy.newProxyInstance(entityIface.getClassLoader(), interfaces, new PartialEntityInvocationHandler<E>(entityMethodsMap, currentState)));
    }
}

