/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal;

import com.google.common.collect.ImmutableMap;
import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.Hierarchy;
import com.kenshoo.pl.entity.SupportedChangeOperation;
import com.kenshoo.pl.entity.ValidationError;
import com.kenshoo.pl.entity.internal.ChangesFilter;
import com.kenshoo.pl.entity.internal.IsFieldReferringToParent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RequiredFieldsChangesFilter<E extends EntityType<E>>
implements ChangesFilter<E> {
    private final Set<EntityField<E, ?>> requiredFields;

    public RequiredFieldsChangesFilter(Set<EntityField<E, ?>> requiredFields) {
        this.requiredFields = requiredFields;
    }

    @Override
    public <T extends EntityChange<E>> Collection<T> filter(Collection<T> changes, ChangeOperation changeOperation, ChangeContext context) {
        List requiredFields = this.entityType().map(entityType -> this.only(this.requiredFields, this.notReferringToParentIn(context.getHierarchy(), (EntityType<E>)entityType))).orElse(Collections.emptyList());
        if (requiredFields.isEmpty()) {
            return changes;
        }
        return changes.stream().filter(change -> requiredFields.stream().allMatch(entityField -> {
            boolean fieldSpecified;
            boolean bl = fieldSpecified = change.isFieldChanged(entityField) && change.get(entityField) != null;
            if (!fieldSpecified) {
                context.addValidationError((EntityChange<? extends EntityType<?>>)change, new ValidationError("persistence.field_is_required", (EntityField<?, ?>)entityField, (Map<String, String>)ImmutableMap.of((Object)"field", (Object)entityField.toString())));
            }
            return fieldSpecified;
        })).collect(Collectors.toList());
    }

    private Predicate<EntityField<E, ?>> notReferringToParentIn(Hierarchy hierarchy, EntityType<E> entityType) {
        return new IsFieldReferringToParent<E>(hierarchy, entityType).negate();
    }

    private Optional<EntityType<E>> entityType() {
        return this.requiredFields.stream().findFirst().map(EntityField::getEntityType);
    }

    private <T> List<T> only(Collection<T> items, Predicate<T> predicate) {
        return items.stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    public Stream<? extends EntityField<?, ?>> requiredFields(Collection<? extends EntityField<E, ?>> fieldsToUpdate, ChangeOperation changeOperation) {
        return Stream.empty();
    }

    @Override
    public SupportedChangeOperation getSupportedChangeOperation() {
        return SupportedChangeOperation.CREATE;
    }
}

