/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal;

import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeEntityCommand;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.spi.PostFetchCommandEnricher;
import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class SingleFieldEnricher<E extends EntityType<E>, T>
implements PostFetchCommandEnricher<E> {
    @Override
    public final void enrich(Collection<? extends ChangeEntityCommand<E>> changeEntityCommands, ChangeOperation changeOperation, ChangeContext changeContext) {
        changeEntityCommands.stream().filter(this::shouldRunForCommand).filter(this.additionalCommandFilter()).filter(command -> this.additionalPostFetchCommandFilter().test((EntityChange<E>)command, changeContext.getEntity((EntityChange)command))).forEach(command -> command.set(this.enrichedField(), this.enrichedValue((EntityChange<E>)command, changeContext.getEntity((EntityChange)command))));
    }

    @Override
    public final Stream<EntityField<E, ?>> fieldsToEnrich() {
        return Stream.of(this.enrichedField());
    }

    @Override
    public final boolean shouldRun(Collection<? extends EntityChange<E>> commands) {
        return commands.stream().filter(this.additionalCommandFilter()).anyMatch(this::shouldRunForCommand);
    }

    protected abstract EntityField<E, T> enrichedField();

    protected abstract T enrichedValue(EntityChange<E> var1, CurrentEntityState var2);

    protected Predicate<EntityChange<E>> additionalCommandFilter() {
        return entityChange -> true;
    }

    protected BiPredicate<EntityChange<E>, CurrentEntityState> additionalPostFetchCommandFilter() {
        return (entityChange, currentState) -> true;
    }

    protected boolean shouldRunForCommand(EntityChange<E> entityChange) {
        return this.enrichedFieldIsMissing(entityChange);
    }

    private boolean enrichedFieldIsMissing(EntityChange<E> entityChange) {
        return !entityChange.isFieldChanged(this.enrichedField());
    }
}

