/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.google.common.annotations.VisibleForTesting;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FinalEntityState;
import com.kenshoo.pl.entity.Triptional;
import com.kenshoo.pl.entity.audit.FieldAuditRecord;
import com.kenshoo.pl.entity.internal.audit.AuditFieldValueResolver;
import com.kenshoo.pl.entity.internal.audit.AuditedField;
import java.util.Objects;
import java.util.Optional;

public class AuditFieldChangeGenerator {
    public static final AuditFieldChangeGenerator INSTANCE = new AuditFieldChangeGenerator(AuditFieldValueResolver.INSTANCE);
    private final AuditFieldValueResolver auditFieldValueResolver;

    AuditFieldChangeGenerator() {
        this(AuditFieldValueResolver.INSTANCE);
    }

    @VisibleForTesting
    AuditFieldChangeGenerator(AuditFieldValueResolver auditFieldValueResolver) {
        this.auditFieldValueResolver = auditFieldValueResolver;
    }

    <E extends EntityType<E>> Optional<FieldAuditRecord> generate(CurrentEntityState currentState, FinalEntityState finalState, AuditedField<E, ?> field) {
        Objects.requireNonNull(currentState, "A current state is required");
        Objects.requireNonNull(finalState, "A final state is required");
        Objects.requireNonNull(field, "A field is required");
        return Optional.of(field).filter(f -> this.fieldWasChanged(currentState, finalState, (AuditedField)f)).map(f -> this.buildFieldRecord(currentState, finalState, (AuditedField)f));
    }

    private <E extends EntityType<E>, T> boolean fieldWasChanged(CurrentEntityState currentState, FinalEntityState finalState, AuditedField<E, T> field) {
        return !this.fieldStayedTheSame(currentState, finalState, field);
    }

    private <E extends EntityType<E>, T> boolean fieldStayedTheSame(CurrentEntityState currentState, FinalEntityState finalState, AuditedField<E, T> field) {
        Triptional<Object> triptionalCurrentValue = this.auditFieldValueResolver.resolve(field, currentState);
        Triptional<T> triptionalFinalValue = this.auditFieldValueResolver.resolve(field, finalState);
        return triptionalCurrentValue.equals(triptionalFinalValue, field::valuesEqual);
    }

    private <E extends EntityType<E>> FieldAuditRecord buildFieldRecord(CurrentEntityState currentState, FinalEntityState finalState, AuditedField<E, ?> field) {
        FieldAuditRecord.Builder fieldRecordBuilder = FieldAuditRecord.builder(field.getName());
        this.auditFieldValueResolver.resolveToString(field, currentState).ifNotNull(fieldRecordBuilder::oldValue);
        this.auditFieldValueResolver.resolveToString(field, finalState).ifNotNull(fieldRecordBuilder::newValue);
        return fieldRecordBuilder.build();
    }
}

