/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.google.common.annotations.VisibleForTesting;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FinalEntityState;
import com.kenshoo.pl.entity.audit.FieldAuditRecord;
import com.kenshoo.pl.entity.internal.audit.AuditFieldChangeGenerator;
import com.kenshoo.pl.entity.internal.audit.AuditedField;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public class AuditFieldChangesGenerator<E extends EntityType<E>> {
    private final Collection<AuditedField<E, ?>> onChangeFields;
    private final AuditFieldChangeGenerator singleGenerator;

    public AuditFieldChangesGenerator(Stream<? extends AuditedField<E, ?>> onChangeFields) {
        this(onChangeFields, new AuditFieldChangeGenerator());
    }

    @VisibleForTesting
    AuditFieldChangesGenerator(Stream<? extends AuditedField<E, ?>> onChangeFields, AuditFieldChangeGenerator singleGenerator) {
        Objects.requireNonNull(onChangeFields, "onChangeFields must not be null (can be empty)");
        this.onChangeFields = onChangeFields.collect(Collectors.toList());
        this.singleGenerator = singleGenerator;
    }

    Collection<FieldAuditRecord> generate(CurrentEntityState currentState, FinalEntityState finalState) {
        return (Collection)Seq.seq(this.onChangeFields).map(field -> this.singleGenerator.generate(currentState, finalState, field)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

