/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.google.common.annotations.VisibleForTesting;
import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FieldValue;
import com.kenshoo.pl.entity.FinalEntityState;
import com.kenshoo.pl.entity.audit.AuditRecord;
import com.kenshoo.pl.entity.audit.FieldAuditRecord;
import com.kenshoo.pl.entity.internal.EntityIdExtractor;
import com.kenshoo.pl.entity.internal.audit.AuditFieldChangesGenerator;
import com.kenshoo.pl.entity.internal.audit.AuditMandatoryFieldValuesGenerator;
import com.kenshoo.pl.entity.internal.audit.AuditRecordGenerator;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class AuditRecordGeneratorImpl<E extends EntityType<E>>
implements AuditRecordGenerator<E> {
    private final AuditMandatoryFieldValuesGenerator mandatoryFieldValuesGenerator;
    private final AuditFieldChangesGenerator<E> fieldChangesGenerator;
    private final EntityIdExtractor entityIdExtractor;
    private final String entityTypeName;

    public AuditRecordGeneratorImpl(AuditMandatoryFieldValuesGenerator mandatoryFieldValuesGenerator, AuditFieldChangesGenerator<E> fieldChangesGenerator, String entityTypeName) {
        this(mandatoryFieldValuesGenerator, fieldChangesGenerator, EntityIdExtractor.INSTANCE, entityTypeName);
    }

    @VisibleForTesting
    AuditRecordGeneratorImpl(AuditMandatoryFieldValuesGenerator mandatoryFieldValuesGenerator, AuditFieldChangesGenerator<E> fieldChangesGenerator, EntityIdExtractor entityIdExtractor, String entityTypeName) {
        this.mandatoryFieldValuesGenerator = mandatoryFieldValuesGenerator;
        this.fieldChangesGenerator = fieldChangesGenerator;
        this.entityIdExtractor = entityIdExtractor;
        this.entityTypeName = entityTypeName;
    }

    @Override
    public Optional<AuditRecord> generate(EntityChange<E> entityChange, ChangeContext context, Collection<? extends AuditRecord> childRecords) {
        Objects.requireNonNull(entityChange, "entityChange is required");
        AuditRecord auditRecord = this.generateInner(entityChange, context, childRecords);
        if (entityChange.getChangeOperation() == ChangeOperation.UPDATE && auditRecord.hasNoChanges()) {
            return Optional.empty();
        }
        return Optional.of(auditRecord);
    }

    private AuditRecord generateInner(EntityChange<E> entityChange, ChangeContext context, Collection<? extends AuditRecord> childRecords) {
        Objects.requireNonNull(context, "context is required");
        CurrentEntityState currentState = context.getEntity(entityChange);
        FinalEntityState finalState = context.getFinalEntity(entityChange);
        String entityId = this.extractEntityId(entityChange, currentState);
        Collection<FieldValue> mandatoryFieldValues = this.mandatoryFieldValuesGenerator.generate(finalState);
        Collection<FieldAuditRecord> fieldRecords = this.fieldChangesGenerator.generate(currentState, finalState);
        return new AuditRecord.Builder().withEntityType(this.entityTypeName).withEntityId(entityId).withMandatoryFieldValues(mandatoryFieldValues).withOperator(entityChange.getChangeOperation()).withFieldRecords(fieldRecords).withChildRecords(childRecords).build();
    }

    private String extractEntityId(EntityChange<E> entityChange, CurrentEntityState currentState) {
        return this.entityIdExtractor.extract(entityChange, currentState).orElseThrow(() -> new IllegalStateException("Could not extract the entity id for entity type '" + entityChange.getEntityType() + "' from either the EntityChange or the CurrentEntityState, so the audit record cannot be generated."));
    }

    @Override
    @VisibleForTesting
    public String getEntityTypeName() {
        return this.entityTypeName;
    }
}

