/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.audit.AuditTrigger;
import com.kenshoo.pl.entity.internal.audit.AuditedField;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AuditedEntityType<E extends EntityType<E>> {
    private final EntityField<E, ? extends Number> idField;
    private final String name;
    private final Set<? extends AuditedField<?, ?>> externalFields;
    private final SetMultimap<AuditTrigger, ? extends AuditedField<E, ?>> internalFields;

    private AuditedEntityType(EntityField<E, ? extends Number> idField, String name, Set<? extends AuditedField<?, ?>> externalFields, SetMultimap<AuditTrigger, ? extends AuditedField<E, ?>> internalFields) {
        this.idField = idField;
        this.name = name;
        this.externalFields = externalFields;
        this.internalFields = internalFields;
    }

    public EntityField<E, ? extends Number> getIdField() {
        return this.idField;
    }

    public String getName() {
        return this.name;
    }

    public Set<? extends AuditedField<?, ?>> getExternalFields() {
        return this.externalFields;
    }

    public Stream<? extends EntityField<?, ?>> getUnderlyingMandatoryFields() {
        return this.getMandatoryFields().map(AuditedField::getField);
    }

    public Stream<? extends AuditedField<?, ?>> getMandatoryFields() {
        return Stream.of(this.externalFields, this.internalFields.get((Object)AuditTrigger.ALWAYS)).flatMap(Collection::stream);
    }

    public Stream<? extends EntityField<E, ?>> getUnderlyingOnChangeFields() {
        return Stream.of(AuditTrigger.ON_CREATE_OR_UPDATE, AuditTrigger.ON_UPDATE).flatMap(trigger -> this.internalFields.get((Object)trigger).stream()).map(AuditedField::getField);
    }

    public Stream<? extends AuditedField<E, ?>> getInternalFields() {
        return this.internalFields.values().stream();
    }

    public boolean hasInternalFields() {
        return !this.internalFields.isEmpty();
    }

    public static <E extends EntityType<E>> Builder<E> builder(EntityField<E, ? extends Number> idField) {
        return new Builder<E>(idField);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditedEntityType that = (AuditedEntityType)o;
        return new EqualsBuilder().append(this.idField, that.idField).append((Object)this.name, (Object)that.name).append(this.externalFields, that.externalFields).append(this.internalFields, that.internalFields).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.idField).append((Object)this.name).append(this.externalFields).append(this.internalFields).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("idField", this.idField).append("name", (Object)this.name).append("externalFields", this.externalFields).append("internalFields", this.internalFields).toString();
    }

    public static class Builder<E extends EntityType<E>> {
        private final EntityField<E, ? extends Number> idField;
        private String name;
        private Set<? extends AuditedField<?, ?>> externalFields = Collections.emptySet();
        private final SetMultimap<AuditTrigger, AuditedField<E, ?>> internalFields = HashMultimap.create();

        public Builder(EntityField<E, ? extends Number> idField) {
            this.idField = Objects.requireNonNull(idField, "idField is required");
            this.name = idField.getEntityType().getName();
            Stream.of(AuditTrigger.ALWAYS, AuditTrigger.ON_CREATE_OR_UPDATE, AuditTrigger.ON_UPDATE).forEach(trigger -> this.internalFields.putAll((Object)trigger, Collections.emptySet()));
        }

        public Builder<E> withName(String name) {
            this.name = Objects.requireNonNull(name, "A name must be provided");
            return this;
        }

        public Builder<E> withUnderlyingExternalFields(EntityField<?, ?> ... externalFields) {
            if (externalFields == null) {
                this.externalFields = Collections.emptySet();
                return this;
            }
            return this.withUnderlyingExternalFields(Stream.of(externalFields));
        }

        public Builder<E> withUnderlyingExternalFields(Stream<? extends EntityField<?, ?>> externalFields) {
            if (externalFields == null) {
                this.externalFields = Collections.emptySet();
                return this;
            }
            return this.withExternalFields(externalFields.map(f -> AuditedField.builder(f).build()));
        }

        public Builder<E> withExternalFields(Collection<? extends AuditedField<?, ?>> externalFields) {
            this.externalFields = externalFields == null ? Collections.emptySet() : Set.copyOf(externalFields);
            return this;
        }

        public Builder<E> withExternalFields(Stream<? extends AuditedField<?, ?>> externalFields) {
            this.externalFields = externalFields == null ? Collections.emptySet() : externalFields.collect(Collectors.toUnmodifiableSet());
            return this;
        }

        @SafeVarargs
        public final Builder<E> withUnderlyingInternalFields(AuditTrigger trigger, EntityField<E, ?> ... internalFields) {
            Set auditedFields = Arrays.stream(internalFields).map(f -> AuditedField.builder(f).build()).collect(Collectors.toUnmodifiableSet());
            this.internalFields.putAll((Object)trigger, auditedFields);
            return this;
        }

        public final Builder<E> withInternalFields(AuditTrigger trigger, Collection<? extends AuditedField<E, ?>> internalFields) {
            if (trigger != null && internalFields != null) {
                this.internalFields.putAll((Object)trigger, internalFields);
            }
            return this;
        }

        public final Builder<E> withInternalFields(Map<AuditTrigger, ? extends Collection<AuditedField<E, ?>>> internalFields) {
            if (internalFields != null) {
                internalFields.forEach((arg_0, arg_1) -> this.internalFields.putAll(arg_0, arg_1));
            } else {
                this.internalFields.clear();
            }
            return this;
        }

        public AuditedEntityType<E> build() {
            return new AuditedEntityType<E>(this.idField, this.name, this.externalFields, this.internalFields);
        }
    }
}

