/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.ValueConverter;
import com.kenshoo.pl.entity.audit.AuditTrigger;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class AuditedField<E extends EntityType<E>, T> {
    private final EntityField<E, T> field;
    private final String name;
    private final AuditTrigger trigger;

    private AuditedField(EntityField<E, T> field, String name, AuditTrigger trigger) {
        this.field = Objects.requireNonNull(field, "An underlying field must be provided");
        this.name = Objects.requireNonNull(name, "A name must be provided");
        this.trigger = Objects.requireNonNull(trigger, "A trigger must be provided");
    }

    public EntityField<E, T> getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public AuditTrigger getTrigger() {
        return this.trigger;
    }

    public ValueConverter<T, String> getStringValueConverter() {
        return this.field.getStringValueConverter();
    }

    public boolean valuesEqual(T v1, T v2) {
        return this.field.valuesEqual(v1, v2);
    }

    public static <E extends EntityType<E>, T> Builder<E, T> builder(EntityField<E, T> field) {
        return new Builder<E, T>(field);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditedField that = (AuditedField)o;
        return new EqualsBuilder().append(this.field, that.field).append((Object)this.name, (Object)that.name).append((Object)this.trigger, (Object)that.trigger).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.field).append((Object)this.name).append((Object)this.trigger).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("field", this.field).append("name", (Object)this.name).append("trigger", (Object)this.trigger).toString();
    }

    public static class Builder<E extends EntityType<E>, T> {
        private final EntityField<E, T> field;
        private String name;
        private AuditTrigger trigger;

        public Builder(EntityField<E, T> field) {
            this.field = Objects.requireNonNull(field, "An underlying field must be provided");
            this.name = field.toString();
            this.trigger = AuditTrigger.ON_CREATE_OR_UPDATE;
        }

        public Builder<E, T> withName(String name) {
            this.name = name;
            return this;
        }

        public Builder<E, T> withTrigger(AuditTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        public AuditedField<E, T> build() {
            return new AuditedField<E, T>(this.field, this.name, this.trigger);
        }
    }
}

