/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeFlowConfig;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.audit.AuditRecord;
import com.kenshoo.pl.entity.internal.audit.AuditRecordGenerator;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RecursiveAuditRecordGenerator {
    public <E extends EntityType<E>> Stream<? extends AuditRecord> generateMany(ChangeFlowConfig<E> flowConfig, Stream<? extends EntityChange<E>> entityChanges, ChangeContext changeContext) {
        return flowConfig.auditRecordGenerator().map(auditRecordGenerator -> this.generateMany(flowConfig, (AuditRecordGenerator)auditRecordGenerator, entityChanges, changeContext)).orElse(Stream.empty());
    }

    private <E extends EntityType<E>> Stream<? extends AuditRecord> generateMany(ChangeFlowConfig<E> flowConfig, AuditRecordGenerator<E> auditRecordGenerator, Stream<? extends EntityChange<E>> entityChanges, ChangeContext changeContext) {
        return entityChanges.map(entityChange -> this.generateOne(flowConfig, auditRecordGenerator, (EntityChange)entityChange, changeContext)).filter(Optional::isPresent).map(Optional::get);
    }

    private <E extends EntityType<E>> Optional<? extends AuditRecord> generateOne(ChangeFlowConfig<E> flowConfig, AuditRecordGenerator<E> auditRecordGenerator, EntityChange<E> entityChange, ChangeContext changeContext) {
        Collection childAuditRecords = flowConfig.childFlows().stream().flatMap(childFlowConfig -> this.generateChildrenUntyped((ChangeFlowConfig<? extends EntityType<?>>)childFlowConfig, entityChange, changeContext)).collect(Collectors.toList());
        return auditRecordGenerator.generate(entityChange, changeContext, childAuditRecords);
    }

    private <E extends EntityType<E>> Stream<? extends AuditRecord> generateChildrenUntyped(ChangeFlowConfig<? extends EntityType<?>> childFlowConfig, EntityChange<E> entityChange, ChangeContext changeContext) {
        return this.generateChildrenTyped(childFlowConfig, entityChange, changeContext);
    }

    private <P extends EntityType<P>, C extends EntityType<C>> Stream<? extends AuditRecord> generateChildrenTyped(ChangeFlowConfig<C> childFlowConfig, EntityChange<P> entityChange, ChangeContext changeContext) {
        return this.generateMany(childFlowConfig, entityChange.getChildren(childFlowConfig.getEntityType()), changeContext);
    }
}

